import React from 'react'
import EventBus from '../../../service/EventBus' 
export default class AudioPlayer extends React.PureComponent {

    myAudio;
    
    constructor(props) {
        super(props)
    } 

    componentDidMount() {
        this.getAudio();
        EventBus.onSingle('PLAY_AUDIO',this.play.bind(this))
    }  

    // 获取音频
    getAudio = () => {
        const myAudio = this.myAudio = new Audio()
        myAudio.preload = true;
        myAudio.loop = false;
        myAudio.src = './public/dingdong.ogg';  
        document.getElementById("audioBox").appendChild(myAudio);
    }

    play() {
        this.myAudio.play();
    }


    render() { 
        return (
            <div id='audioBox' />
        );
    }
} 