/**
 * 【待付款  10; 已取消 0 ； 已关闭 -1 ； 待接单  20  ； 待收货 （25 /30） ; 已完成 40】 
 * 【0：到店自提 1：商家配送 2：快递配送】
 * 【支付方式 0:线下付款;1:微信支付;2:货到付款;3:支付宝支付 4qq支付 5 微信小程序】
 */
import React from 'react'
import { Button } from 'antd'

import { MoneytoFixed, TimeFormat,SingleTimeFormat } from '../../../../service/utils'

import TimeCutDown from '../../../../service/TimeCutDown'

module.exports = {

    /**
     * 配送信息
     */
    getShipingLabel(order) {
        let shipingLable =
            <div class="address">
                <p class="mb0">送达时间</p>
                <p className='fonts16 fontweightbold'  >{TimeFormat(order.deliveryTime, order.deliveryTimeEnd)}</p>
                <p className='fonts16 fontweightbold'>{order.reciverInfo.address}</p>
                <p className='fonts16 fontweightbold'>{order.reciverInfo.trueName}  {order.reciverInfo.mobPhone || order.reciverInfo.telPhone} </p>
            </div>;
        if (order.shippingType == 0) {
            shipingLable =
                <div class="delivery-msg part-bd">
                    <p>买家自提(自提时间：{SingleTimeFormat(order.deliveryTime)})</p>
                    <p className='fonts20 colorblue'>取件码：{order.dlyoPickupCode}</p>
                    <p>{order.reciverInfo.trueName}  {order.reciverInfo.mobPhone || order.reciverInfo.telPhone} </p>
                </div>
        }
        return shipingLable;
    },

    /**
     * 状态
     */
    getStatusLabel(order,master) {
        let statusLable = '';
        switch (order.orderState) {
            case 20:
                statusLable =
                    <div>
                        <div className="colory"><TimeCutDown startTime={order.serverTime} endTime={order.addTime} timeEnd={()=>{master.timeEnd()}}/>后自动关闭</div>
                    </div>
                break;
            case 10:
                statusLable = '待线上付款'
                break;
            case 25:
            case 30:
                if (order.shippingType == 0) {
                    statusLable = '待到店自取'
                } else {
                    statusLable = '待配送'
                }
                break;
            case 40:
                statusLable = '已完成'
                break;
            case 0:
                statusLable = '已取消'
                break;
            case -1:
                statusLable = '已关闭'
                break;
            default: break;
        }

        return statusLable;
    },

    /**
     * 订单配送费用信息
     * @param {*} order 
     */
    getLabelShow(order) {
        let payState = '';
        let payLabelState = '';
        if (order.isReceivePayment > 0) { //已支付
            payState = <div><div className='money-title'>实付金额：</div>
                <div className='money-content'>￥{MoneytoFixed(order.orderAmount)}</div> </div>
            switch (order.paymentType) {
                case 0:
                    payLabelState = <span>线下付款，已核实</span>
                    break;
                case 1:
                    payLabelState = <span>线上付款</span>
                    break;
                case 2:
                    payLabelState = <span>货到付款</span>
                    break;
                case 3:
                    payLabelState = <span>线上付款</span>
                    break;
                default: break;
            }
        } else {//未支付 
            payState = <div className='colory'><div className='money-title'>应收金额：</div>
                <div className='money-content'>￥{MoneytoFixed(order.orderAmount)}</div> </div>
            switch (order.paymentType) {
                case 0:
                    payLabelState = <span className='colory'>线下付款，请核实</span>
                    break;
                case 1:
                    payLabelState = <span>待线上支付</span>
                    payState = <div className='colory'><div className='money-title'>待付金额：</div>
                        <div className='money-content'>￥{MoneytoFixed(order.orderAmount)}</div> </div>
                    break;
                case 2:
                    payLabelState = <span className='colory'>货到付款</span>
                    break;
                case 3:
                    payLabelState = <span>待线上支付</span>
                    payState = <div className='colory'><div className='money-title'>待付金额：</div>
                        <div className='money-content'>￥{MoneytoFixed(order.orderAmount)}</div> </div>
                    break;
                default: break;
            }
        }

        return { payState, payLabelState }
    },



    /**
     * 店家操作
     */
    getOptLabel(order, master) {
        let opts = '';
        order._deliver = order._deliver || order.deliveryman;
        if (order.isReceivePayment > 0) { //已支付 
            switch (order.orderState) {
                case 20: //待接单
                    opts = <Button className='footer-button-white'  onClick={() => { master.onOrderReceive(order) }}>接单</Button>
                    break;
                case 25:
                case 30:
                    if (order.shippingType != 0) {
                        opts =
                            <div>
                                {
                                     (order._deliver && order._deliver.trueName) ?
                                        <Button className='footer-button-white' onClick={() => { master.onGetDeliveriers(order) }}>配送员：{order._deliver.trueName}</Button> :
                                        <Button className='footer-button-white'  onClick={() => { master.onGetDeliveriers(order) }}>选择配送人员</Button>
                                }
                                <Button className='footer-button-white' onClick={() => { master.onPrint(order) }}>打印订单</Button>
                            </div>
                    } else {
                        opts =
                            <div>
                                <Button className='footer-button-white'  onClick={() => { master.onPrint(order) }}>打印订单</Button>
                            </div>
                    }
                    break;
                default: break;
            }
        } else {//未支付  
            switch (order.orderState) {
                case 20:
                    opts =
                        <div>
                            <Button className='footer-button-white'   onClick={() => { master.onModifyPrice(order) }}>修改价格</Button>
                            <Button className='footer-button-white'   onClick={() => { master.onOrderReceive(order) }}>接单</Button>
                        </div>
                    break;
                case 10:
                    opts =
                        <div>
                            <Button className='footer-button-white'   onClick={() => { master.onModifyPrice(order) }}>修改价格</Button>
                        </div>
                    break;
                case 25:
                case 30:
                    if (order.shippingType == 0) {
                        opts =
                            <div>
                                <Button className='footer-button-white'  onClick={() => { master.onModifyPrice(order) }}>修改价格</Button>
                                <Button className='footer-button-white'   onClick={() => { master.onReceivePayment(order) }}>确认收款</Button>
                                <Button className='footer-button-white'   onClick={() => { master.onPrint(order) }}>打印订单</Button>
                            </div>
                    } else {
                        opts =
                            <div>
                                <Button className='footer-button-white'  onClick={() => { master.onModifyPrice(order) }}>修改价格</Button>
                                <Button className='footer-button-white'  onClick={() => { master.onReceivePayment(order) }}>确认收款</Button>
                                {
                                    (order._deliver && order._deliver.trueName)?
                                        <Button className='footer-button-white' onClick={() => { master.onGetDeliveriers(order) }}>配送员：{order._deliver.trueName}</Button> :
                                        <Button className='footer-button-white'   onClick={() => { master.onGetDeliveriers(order) }}>选择配送人员</Button>
                                }
                                <Button className='footer-button-white'   onClick={() => { master.onPrint(order) }}>打印订单</Button>
                            </div>
                    }
                    break;
                default: 
                    break;
            }
        }

        return opts;
    }
}