import React from 'react'
import Distribution from '../../commonComponent/Order/Distribution/Distribution'
import BaseCmpt from '../../../cmpt/basecmpt'
import orderApi from '../../../api/orderApi'
import { Pagination, Alert } from 'antd'
export default class OrderDistribution extends BaseCmpt {
    constructor(props) {
        super(props)
        this.state = {
            orders: [],
            total: 0,
            current: 1
        }
    }

    componentDidMount() {
        this.loadData(1)
    }

    loadData(page) {
        var self = this;
        orderApi.orderList(page, 101).then(function (res) {
            var _orders = res.responseContent.orders || [];
            var _total = res.responseContent.totalCount || 0;
            var _servTime = res.responseTime || Math.floor(new Date().getTime() / 1000)
            self.setState({
                orders: _orders,
                total: _total,
                serverTime:_servTime
            })
        })
    }

    onChangePage(page, pageSize) {
        this.setState({
            current: page
        })
        this.loadData(page)
    }

    render() {
        let { orders,
            total,
            current ,serverTime} = this.state;
        return (
            <React.Fragment>
                {
                    orders.map(function (order) {
                        return <Distribution key={order.orderId} order={order} serverTime={serverTime}/>
                    })
                }
                <div className="pagination-wrap">
                    {
                        (orders && orders.length > 0) ?
                            <Pagination className="pagination-main" defaultPageSize={10} current={current} total={total} onChange={(page, pageSize) => { this.onChangePage(page, pageSize) }} />
                            :<div  className="nodata">暂无数据</div>
                    }
                </div>
            </React.Fragment>
        );
    }
}