import React from 'react'
import ShouhouAll from "../../commonComponent/Shouhou/Shouhou"

import refundsApi from '../../../api/refundsApi'
import { Pagination } from 'antd' 

export default class ShouhouReceive extends React.Component {

    constructor(props) {
        super(props)
        this.state = {
            refunds: [],
            total: 0,
            current: 1
        }
    }

    componentDidMount() {
        this.loadData(1)
    }

    loadData(page) {
        var self = this;
        refundsApi.getRefunds(page, 2).then(function (res) {
            var _refunds = res.responseContent.refundReturns || [];
            var _total = res.responseContent.totalCount || 0;
            self.setState({
                refunds: _refunds,
                total: _total
            })
        })
    }

    onChangePage(page, pageSize) {        
        this.setState({
            current: page
        })
        this.loadData(page)
    }

    render() {
        let { refunds, current, total } = this.state;
        return (
            <React.Fragment>
                {
                    refunds.map(function (ret) {
                        return (
                            <ShouhouAll key={ret.refundId} retItem={ret} />
                        )
                    })
                }


                <div className="pagination-wrap">
                    {
                        (refunds && refunds.length > 0) ? <Pagination className="pagination-main" defaultPageSize={10} current={current} total={total} onChange={(page, pageSize) => { this.onChangePage(page, pageSize) }} />
                            : <div  className="nodata">暂无数据</div>
                    }
                </div>
            </React.Fragment>
        );
    }
}