import React from 'react';
import Modal from './ModalSubject';


import { Button ,Input} from 'antd'

import ZZmage from '../../commonComponent/ZZmage'

export default class AddStock extends React.Component {

    constructor(props) {
        super(props)
        this.props = props
        this.state = {
            num: ''
        }

    }

    changeText(e) {
        let val = e.target.value;
        this.setState({
            num: val
        })
    }

    ok() {
        if (this.props.onHandle) {
            this.props.onHandle(this.state.num)
        }
    }

    render() {
        let { stock } = this.props
        let { num } = this.state
        return (
            <Modal close={this.props.close} title='增补库存' height={'300px'}>
                <div className='modal-content-content modal-content-content-style'>
                    <div className="info-box">
                        <div className="pic">
                            <img className='add-stock-img' src={stock.goodsImage} alt="" />
                        </div>
                        <div className="detail">
                            <div className="tit">{stock.goodsName}</div>
                            <div className="fonts12 colorg margint5">
                                {
                                    stock.goodsAttr && stock.goodsAttr.map(function (r) {
                                        return <span key={r.attrValue}> {r.attrName + ' '} </span>
                                    })
                                }
                            </div>
                        </div>
                    </div>
                    <div className='clear-float margint20'>
                        <span>增补库存：</span>
                        <Input type="text" className='add-input width300' value={num} placeholder='请输入库存数量' onChange={(e) => { this.changeText(e) }} />
                    </div>
                </div>
                <div className='modal-content-btn'>
                    <Button className='modal-footer-btn ant-btn-orange' onClick={() => { this.ok() }}>确定</Button>
                    <Button className='modal-footer-btn-white' onClick={this.props.close}>取消</Button>
                </div>
            </Modal>
        );
    }
}