import React from 'react';
import Modal from './ModalSubject';
import { Button, InputNumber, Checkbox } from 'antd';

import { MoneytoFixed } from '../../../service/utils'

import EventBus from '../../../service/EventBus'

export default class AgreeRefund extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            val: '',
            reson: '',
            isGiveUp: 0
        }
    }

    allIn() {
        var k = MoneytoFixed(this.props.refundAmount || 0)
        this.setState({
            val: k
        })
    }

    onTextChange(e, t) {
        if (t == 'v') {
            var _val = e
            this.setState({
                val: _val
            })
        } else if (t == 'r') {
            var _val = e.target.value
            this.setState({
                reson: _val
            })
        }
    }

    onHandle() {
        var n = Number(this.state.val)
        if (Number.isNaN(n) || '' === this.state.val) {
            EventBus.emit('ERROR_API', '请输入有效金额')
            return;
        }
        if (this.props.title == '同意退款') {
            this.state.isGiveUp = 1
        }
        if (this.props.onHandle) {
            this.props.onHandle(n, this.state.reson, this.state.isGiveUp)
        }
    }

    limitDecimals(value) {
        const reg = /^(\-)*(\d+)\.(\d\d).*$/;
        if (typeof value === 'string') {
            return !isNaN(Number(value)) ? value.replace(reg, '$1$2.$3') : ''
        } else if (typeof value === 'number') {
            return !isNaN(value) ? String(value).replace(reg, '$1$2.$3') : ''
        } else {
            return ''
        }
    }

    checkBoxChange(e) {
        var checked = e.target.checked;
        this.state.isGiveUp = checked ? 1 : 0;        
    }

    render() {
        let {
            val,
            reson
        } = this.state
        return (
            <Modal close={this.props.close} title={this.props.title} height={'350px'}>
                <div className='modal-content-content modal-content-content-style'>
                    <div className='colory dlg-agree-refund-tip marginb10'>
                        若买家是线下付款或到货收款，请跟买家沟通退款方式。
                    </div>
                    {
                        this.props.title == '同意退款' ? null :
                            <div className='clear-float marginb10 margint10'>
                                <p className="width80"></p>  <Checkbox onChange={(e) => { this.checkBoxChange(e) }}>弃货</Checkbox>
                            </div>
                    }
                    <div className='clear-float' className="marginb10 ">
                        <p className="width80">退款金额：</p>
                        <InputNumber className="width240" min={0}
                            step={1.00}
                            formatter={this.limitDecimals}
                            parser={this.limitDecimals}
                            value={val} onChange={(e) => { this.onTextChange(e, 'v') }} />
                        <Button className="width80 btn-refund-all" onClick={() => { this.allIn() }}>全额退款</Button>
                    </div>
                    <div className='clear-float'>
                        <p className="width80">备注说明：</p>
                        <textarea className="width320" name="" id="" cols="40" rows="4" value={reson} onChange={(e) => { this.onTextChange(e, 'r') }}></textarea>
                    </div>
                </div>
                <div className='modal-content-btn'>
                    <Button className='modal-footer-btn ant-btn-orange' onClick={() => { this.onHandle() }}>确定</Button>
                    <Button className='modal-footer-btn-white' onClick={this.props.close}>取消</Button>
                </div>
            </Modal>
        );
    }
}