import React from 'react';
import Modal from './ModalSubject';
import IconUser from '../../imgs/ava.png';

import orderApi from '../../../api/orderApi'

import EventBus from '../../../service/EventBus'

import { Button, Radio, Input, InputNumber, Checkbox} from 'antd';

const RadioGroup = Radio.Group;

export default class ChooseDistributor extends React.Component {

    constructor(props) {
        super(props)
        this.state = {
            list: [],
            selected: this.props.selectedDeliverierId,
            radioVal: this.props.payDeliverier,
            mobile: '',
            name: '',
            isCreated: 0
        }
    }

    /**
     * 1、配送员列表
     * 2、新增配送员
     * 3、确认
     */
    componentDidMount() {        
        this.loadList()
    }

    loadList = () => {
        let self = this;
        return orderApi.getDeliveriers().then(function (res) {
            self.setState({
                list: res.responseContent
            })
        })
    }

    changeTextX(e, label) {
        var val = e.target.value;
        if (label == 'm') {
            this.setState({
                mobile: val,
            })
        } else if (label == 'n') {
            this.setState({
                name: val,
            })
        }
    }

    checkBoxChange(e) {
        var checked = e.target.checked;
        this.setState({
            isCreated: checked ? 1 : 0,
            selected: ''
        })
    }

    onAdded() {
        var mobile = this.state.mobile;
        var name = this.state.name;
        if(!!!name&&!!!mobile){
            EventBus.emit('ERROR_API', '请输入配送员名字和手机号')
            return;
        }else if (!!!name) {
            EventBus.emit('ERROR_API', '请输入配送员名字')
            return;
        }else if (!!!mobile) {
            EventBus.emit('ERROR_API', '请输入配送员手机号')
            return;
        }        
        var name = this.state.name;
        var self = this;
        orderApi.addDelivery(mobile, name).then(function (res) {
            if (res.resultCode == 1) {
                self.state.selected =  res.responseContent ;
                self.loadList().then(function (resp) {
                    self.handleSelected()
                })
            }
        })

    }

    onSelected() {      
        if ((this.state.radioVal == undefined)) {
            EventBus.emit("ERROR_API", "请输入有效配送费")
            return;
        }
        if (this.state.isCreated == 1) {
            this.onAdded()
        } else {
            this.handleSelected()
        }
    }

    handleSelected() {
        const id  = this.state.selected;
        let filters = this.state.list.filter(function (item) {
            return item.id == id
        })
        if (filters.length == 0) {
            EventBus.emit("ERROR_API", "请选择一个配送人员")
            return;
        }
        if (this.props.onSelected) {
            this.props.onSelected(filters[0], this.state.radioVal)
        }
    }

    handleChange = (e) => {      
        var val = e.target.value;       
        this.setState({
            selected: val,
            isCreated: 0
        })        
    }

    changeText(e) {
        this.setState({
            radioVal: e
        })
    }

    limitDecimals(value) {
        const reg = /^(\-)*(\d+)\.(\d\d).*$/;
        if (typeof value === 'string') {
            return !isNaN(Number(value)) ? value.replace(reg, '$1$2.$3') : ''
        } else if (typeof value === 'number') {
            return !isNaN(value) ? String(value).replace(reg, '$1$2.$3') : ''
        } else {
            return ''
        }
    }

    render() {
        let { list, selected, radioVal, mobile, name, isCreated } = this.state;
        let self = this; 
        
        return (
            <Modal close={this.props.close} title='选择配送员' height='100%'>
                <div className='modal-content-content modal-content-content-style dlg-choose-wrap'>
                    <div className='clear-float'>
                        {
                            list ?
                                <RadioGroup onChange={this.handleChange} value={this.state.selected}>
                                    {
                                        list.map(function (item, index) {
                                            return <div className="dlg-item" key={index}><Radio className="dlg-choose-radiostyle" value={item.id}><img src={item.memberAvatar} /><span className="name">{item.trueName}</span></Radio></div>
                                        })
                                    }
                                </RadioGroup> : null
                        }
                    </div>
                    <div className='clear-float marginb10 margint20'>
                        <Checkbox checked={isCreated == 1 ? true : false} onChange={(e) => { this.checkBoxChange(e) }}>新增并选定配送员</Checkbox>
                    </div>
                    {
                        isCreated == 1 ?
                            <div className='new-diliveryman'>
                                <div className='colory fonts12'>
                                    配送员需先注册成为【我的身边店】用户。
                                </div>
                                <div className='margint10'>
                                    <Input type="text" className='add-input width170' placeholder='请输入配送员姓名' value={name} onChange={(e) => { this.changeTextX(e, 'n') }} />
                                    <Input type="text" className='add-input width170' placeholder='请输入配送员手机号码' value={mobile} onChange={(e) => { this.changeTextX(e, 'm') }} />
                                </div>
                            </div> : null
                    }

                    <div className="dlg-choose-wrap-div marginTop20">
                        <span className='modal-form-label' >配送费用：</span>
                        <InputNumber type="text" className='add-input width300'
                            min={0}
                            step={1.00}
                            formatter={this.limitDecimals}
                            parser={this.limitDecimals} placeholder='请输入支付给配送员的金额' value={radioVal} onChange={(e) => { this.changeText(e) }} />
                    </div>
                    <div className='modal-content-btn'>
                        {/* <Button className='modal-footer-btn-white marginRight10'   onClick={this.props.onAddDistributer}>新增配送员</Button> */}
                        <Button className='modal-footer-btn ant-btn-orange' onClick={() => { this.onSelected() }}>确认</Button>
                        <Button className='modal-footer-btn-white' onClick={this.props.close}>取消</Button>
                    </div>
                </div>

            </Modal>
        );
    }
}