import React from 'react';

import Utils from './fragment'

import ChooseDistributor from '../../Modal/ChooseDistributor'

import AddDistributer from '../../Modal/AddDistributer'

import ModifyPriceModal from '../../Modal/ModifyPriceModal'

import PrintModal from '../../../more/PrintModal'

import OkModal from '../../Modal/OkModal'

import orderApi from '../../../../api/orderApi';

import ZZmage from '../../../commonComponent/ZZmage'

import { MoneytoFixed, TimeFormatFull} from '../../../../service/utils'

import TimeCutDown from '../../../../service/TimeCutDown'
import EventBus from '../../../../service/EventBus'



export default class Distribution extends React.Component {

    constructor(props) {
        super(props)
        this.props = props;
        props.order.serverTime = props.serverTime
        this.state = {
            order: props.order,
            selectMDeliverier: false,
            addMDeliverier: false,
            showModifyPriceModal: false,
            showPrintModal: false,
            showAskModal: false,
            selectedDeliverierId:'',
            payDeliverier:0
        }
    }

    componentDidMount() {
        EventBus.onSingle('RELOAD_ORDER_' + this.props.order.orderId, function (e) {
            var self = this;
            orderApi.orderDetail(this.props.order.orderId).then(function (res) {
                self.props.order = res.responseContent;
                self.setState({
                    order: res.responseContent
                })
            })
        }.bind(this))
    }

    handleClose = () => {
        this.setState({
            selectMDeliverier: false
        });
    } 

    /**
     * 新增配送员，跳转到选择界面
     */
    handleAdded = () => {
        this.handleCloseX();
    }

    /**
     * 关闭添加对话框，但需要打开选择界面
     */
    handleCloseX = () => {
        this.setState({
            selectMDeliverier: true,
            addMDeliverier: false
        });
    }

    /**
     * 处理选择配送员
     */
    handleSelected = (deliver, val) => {
        let self = this;
        orderApi.selectDelivery(this.state.order.orderId, deliver.id, val).then(function (res) {
            if (res.resultCode == 1) {
                self.setState({
                    selectMDeliverier: false,
                    order: res.responseContent
                });                              
            }
        })

    }

    /**
     * 处理对话弹出新增配送员框
     */
    handleAddDistributer = () => {
        this.setState({
            selectMDeliverier: false,
            addMDeliverier: true
        });
    }

    /**
     * 修改价格 1
     */
    onModifyPrice(order) {
        this.setState({
            showModifyPriceModal: true
        })
    }
    handleModifyPrice(p) {
        let self = this;
        let { order } = this.state
        var k = Number(p);
        if (Number.isNaN(k)) {
            return;
        }
        orderApi.modifyOrderAmount(order.orderId, k * 100).then(function (res) {
            if (res.resultCode == 1) {
                self.setState({
                    order: res.responseContent,
                    showModifyPriceModal: false
                })
            }
        })
    }

    /**
     * 打印 1
     */
    onPrint(order) {
        this.setState({
            showPrintModal: true
        })
    }

    handlePrint() {
        
    }

    /**
     * 商家接单操作 1
     */
    onOrderReceive(order) {
        var self = this;
        orderApi.orderReceive(order.orderId).then(function (res) {
            if (res.resultCode == 1) {
                self.setState({
                    order: res.responseContent
                })
            }
        })
    }

    /**
     * 获得配送员列表 1
     */
    onGetDeliveriers(order) {
        this.setState({
            selectMDeliverier: true                      
        })
        if(order.deliveryman&&order.deliveryman.trueName){
            this.setState({
                selectedDeliverierId:order.diliverymanId,
                payDeliverier:MoneytoFixed(order.deliveryman.distributionFee)
            })
        }
    }

    /**
     * 确认收款 1
     */
    onReceivePayment(order) {

        this.setState({
            showAskModal: true
        })
    }


    handleReceivePayment() {

        this.setState({
            showAskModal: false
        })
        var self = this;
        let { order } = this.state
        orderApi.receivePayment(order.orderId).then(function (res) {
            if (res.resultCode == 1) {
                self.setState({
                    order: res.responseContent
                })
            }
        })
    }

    timeEnd() {
        var o = this.state.order;
        o.orderState = -1;
        this.setState({
            order: o
        })
    }





    render() {
        let self = this;
        let { order } = self.state;
        let { payState, payLabelState } = Utils.getLabelShow(order)
        let optLabel = Utils.getOptLabel(order, self);
        let statusLabel = Utils.getStatusLabel(order, self);
        let shippingLabel = Utils.getShipingLabel(order);
        let {
            selectMDeliverier,
            addMDeliverier,
            showModifyPriceModal,
            showPrintModal,
            showAskModal,
            selectedDeliverierId,
            payDeliverier
        } = this.state;
        return (
            <React.Fragment>
                <div className='content-each'>
                    <div className='content-each-in'>
                        <div className='content-each-left'>
                            <div className='content-each-left-part1'>
                                {shippingLabel}
                            </div>
                            {
                                order.deliveryman ?
                                    <div className='content-each-left-part2 part-bd'>
                                        <div>配&ensp;送&ensp;员：{order.deliveryman.trueName}</div>
                                        <div>配&ensp;送&ensp;费：￥{MoneytoFixed(order.deliveryman.distributionFee)}</div>
                                    </div> : null
                            }

                            <div className='content-each-left-part2'>
                                <p className='fonts16'>{payLabelState}</p>
                                <div className='money'>
                                    <div className='money-title'>订单金额：</div>
                                    <div className='money-content'>￥{MoneytoFixed(order.goodsAmount)}</div>
                                </div>
                                <div className='money'>
                                    <div className='money-title'>服&ensp;务&ensp;费：</div>
                                    <div className='money-content'>￥{MoneytoFixed(order.shippingFee)}</div>
                                </div>
                                <div className='money'>
                                    <div className='money-title'>优惠金额：</div>
                                    <div className='money-content'>￥{MoneytoFixed(order.couponAmount)}</div>
                                </div>
                                <div className='money'>
                                    {payState}
                                </div>
                            </div>
                            <div className='content-each-left-part3 fonts12'>
                                <p>订单编号：{order.orderSn}</p>
                                <div class="info-tip-box">
                                    <p class="info-btn-more"><i class="ico-more"></i></p>
                                    <div class="info-tip">
                                        <p>买&emsp;&emsp;家：{order.buyerName}</p>
                                        <p>下单时间：{TimeFormatFull(order.addTime)}</p>
                                        {
                                            order.sendTime?
                                            <p>发货时间：{TimeFormatFull(order.sendTime)}</p>:null
                                        }                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div className='content-each-right'> 
                        {
                            order.orderGoods && order.orderGoods.map(function (goods) {
                                return ( 
                                    <div className="marginb5">
                                        <div className="each-right-wrap">
                                            <div className='each-right' key={goods.orderId}>
                                                <div className='each-right-left'>
                                                    <ZZmage className='book-img' src={goods.goodsImage} alt=""/>
                                                </div>
                                                <div className='each-right-center'>
                                                    <div className='eachbook-title fonts14'>{goods.goodsName}</div>
                                                    {
                                                        (goods && goods.goodsGroup.length > 0) ?
                                                            <div className='eachbook-footer'>
                                                                <span className='colory fontweightbold fonts16'>￥{MoneytoFixed(goods.goodsPayPrice)}</span>
                                                                {
                                                                    goods.goodsPayPrice===goods.goodsOriginPrice? null: <span className="colorg marginl20 td-lt">￥{MoneytoFixed(goods.goodsOriginPrice)}</span>
                                                                }
                                                                
                                                            </div>
                                                            :
                                                            <div className='eachbook-footer fonts12 colorg'>
                                                                {
                                                                    goods.goodsAttr.map(function (r, index) {
                                                                        return <span key={index}> {(index == 0 ? '' : ';') + r.attrValue} </span>
                                                                    })
                                                                }

                                                            </div>
                                                    }

                                                </div>
                                                <div className='each-right-right'>
                                                    <div className='eachbook-title-right'>x{goods.goodsNum}</div>
                                                    {
                                                        (goods && goods.goodsGroup.length > 0) ? null : <div className='eachbook-content-right'>￥{MoneytoFixed(goods.goodsPrice)}</div>
                                                    }

                                                </div>
                                            </div>
                                            <div className="refund-stateName-wrap"><div className="refund-stateName colory">{goods.refundStateName}</div></div>
                                        </div>
                                        {
                                            (goods && goods.goodsGroup.length > 0) ?
                                                <div className="goods-group">
                                                    <div className='dapei'>搭配商品</div>
                                                    {
                                                        goods.goodsGroup && goods.goodsGroup.map(function (grp, index) {
                                                            return (
                                                                <div className='each-right'>
                                                                    <div className='each-right-left'>
                                                                        <ZZmage className='book-img' src={grp.goodsImage} alt=""/>
                                                                    </div>
                                                                    <div className='each-right-center'>
                                                                        <div className='eachbook-title fonts14'>{grp.goodsName}</div>
                                                                        <div className='eachbook-footer'>          
                                                                            <div className="fonts12 colorg">
                                                                                {
                                                                                    grp.goodsAttr.map(function (r, index) {
                                                                                        return <span key={index}> {(index == 0 ? '' : ';') + r.attrValue} </span>
                                                                                    })
                                                                                }
                                                                            </div>
                                                                        </div>
                                                                        <div className="eachbook-price">
                                                                            <span className="fonts16">￥{MoneytoFixed(grp.discountPrice)}</span>
                                                                            {
                                                                                grp.discountPrice===grp.goodsPrice ? null:  <span className="colorg marginl20 td-lt">￥{MoneytoFixed(grp.goodsPrice)}</span> 
                                                                            }                
                                                                        </div>  
                                                                    </div>
                                                                    <div className='each-right-right'>
                                                                        <div className='eachbook-title-right'>x {grp.num}</div>
                                                                    </div>
                                                                </div>
                                                            )
                                                        })
                                                    }
                                                </div> : null
                                        }
                                    </div> 
                                )
                            })
                        } 
                        {
                            order.orderMessage?<div className='description-box'><div className="description-item"><div className="description-tit">买家留言：</div><div className="description-detial">{order.orderMessage}</div></div></div>:null
                        }
                        
                        <div className='content-each-right-footer'>
                            <div className='content-each-right-footer-root'>
                                <div className='root-left'>
                                    <div className="colorg">
                                        {statusLabel}
                                    </div>
                                </div>
                                <div className='root-right marginb14'>
                                    {optLabel}
                                </div>
                            </div>
                        </div>
                    </div>
                    </div>
                </div>
                {  
                    selectMDeliverier ? <ChooseDistributor
                        close={this.handleClose}
                        onSelected={this.handleSelected}
                        onAddDistributer={this.handleAddDistributer}
                        selectedDeliverierId = {selectedDeliverierId}
                        payDeliverier = {payDeliverier}
                        ></ChooseDistributor> : ''
                }
                {
                    addMDeliverier ? <AddDistributer
                        close={this.handleCloseX}
                        onAdded={this.handleAdded}></AddDistributer> : ''
                }
                {
                    showModifyPriceModal ? <ModifyPriceModal
                        price={MoneytoFixed(order.orderAmount)}
                        close={function () { self.setState({ showModifyPriceModal: false }) }}
                        onHandle={(p) => { this.handleModifyPrice(p) }}
                    ></ModifyPriceModal> : ''
                }

                {
                    showPrintModal ?
                        <PrintModal close={function () { self.setState({ showPrintModal: false }) }} order={order}
                            onHandle={(p) => { this.handlePrint(p) }} ></PrintModal> : null
                }

                {
                    showAskModal ?
                        <OkModal
                            tipCon={'是否确认收款？'}
                            onHandle={() => { self.handleReceivePayment()}}
                            close={() => { self.setState({ showAskModal: false }) }}>
                        </OkModal> : null
                }                

            </React.Fragment>
        );
    }
}