import React from 'react'

import AntModal from './AntModal'

import { Layout, Button } from 'antd';

const { Header, Footer, Sider, Content } = Layout;

import './more.less'
import TextArea from 'antd/lib/input/TextArea';

import moreApi from '../../api/moreApi'

export default class FeedModal extends React.Component {

    constructor(props) {
        super(props)
        this.props = props;
        this.state = {
            showPanel: 1,
            desc:''
        }
    }

    changeBox(e) {
        this.setState({
            showPanel: e
        })
    }

    saveFeedback() {
        var desc = this.state.desc;
        var self = this;
        moreApi.saveFeedback(desc).then(function(res){
            if(res.resultCode == 1) {
              self.props.close()
            }
        })
    }

    textChanged(e) {
        var val = e.target.value;
        this.setState({
            desc:val
        })
    }



    render() {
        let {
            showPanel,
            desc 
        } = this.state
        return (
            <AntModal close={this.props.close}>
                <div className='feed-wrap'>
                    <div className='top'>
                        意见反馈
                    </div>
                    <div className='input'>
                        <TextArea className='textarea' value={desc} onChange={(e)=>{this.textChanged(e)}}></TextArea>
                    </div>
                    <div className='feed-btn-grp'>
                        <Button className="ant-btn-orange" onClick={()=>{this.saveFeedback()}}>提交</Button> 
                        <Button onClick={this.props.close}>取消</Button>
                    </div>
                </div>
            </AntModal>
        )
    }

}