import React from 'react'
import Distribution from '../../commonComponent/Order/Distribution/Distribution'


import BaseCmpt from '../../../cmpt/basecmpt'
import orderApi from '../../../api/orderApi'

import { Pagination } from 'antd'

import EventBus from '../../../service/EventBus'

export default class OrderManager extends BaseCmpt {

    constructor(props) {
        super(props)
        this.state = {
            orders: [],
            total: 0,
            current: 1,
            tip: false
        }
    }

    componentDidMount() {
        this.loadData(1)
        EventBus.onSingle('NEW_ORDER_TIP', this.showTip.bind(this))
    }

    showTip(rows) {
        EventBus.emit('PLAY_AUDIO')
        this.setState({
            tip: true
        })
    }

    loadData(page) {
        var self = this;
        orderApi.orderList(page).then(function (res) {
            var _orders = res.responseContent.orders || [];
            var _total = res.responseContent.totalCount || 0;
            var _servTime = res.responseTime || Math.floor(new Date().getTime() / 1000)
            self.setState({
                orders: _orders,
                total: _total,
                tip: false,
                serverTime: _servTime
            })
        })
    }

    onChangePage(page, pageSize) {        
        this.setState({
            current: page
        })
        this.loadData(page)
    }

    render() {
        let { orders,
            total,
            current,
            tip,
            serverTime } = this.state;
        return (
            <React.Fragment>
                {
                    tip ? <div className="search-wrap content-each alert-tip" onClick={() => { this.loadData(1) }}>
                        <div className="centre-wrap"> 您有新的订单，点击刷新 </div>

                    </div> : null
                }

                {
                    orders.map(function (item) {
                        return <Distribution key={item.orderId} order={item} serverTime={serverTime}/>
                    })
                }


                <div className="pagination-wrap">
                    {
                        (orders && orders.length > 0) ? <Pagination className="pagination-main" defaultPageSize={10} current={current} total={total} onChange={(page, pageSize) => { this.onChangePage(page, pageSize) }} />
                            : <div  className="nodata">暂无数据</div>
                    }
                </div>

            </React.Fragment>
        )
    }
}