import React from 'react'
import Distribution from '../../commonComponent/Order/Distribution/Distribution'
import BaseCmpt from '../../basecmpt'
import orderApi from '../../../api/orderApi'

import { Pagination, Input, Form, Button } from 'antd'
const FormItem = Form.Item;

export default class OrderWaitPay extends BaseCmpt {
    constructor(props) {
        super(props)
        this.state = {
            orders: [],
            total: 0,
            current: 1,
            keyword: ''
        }
    }

    componentDidMount() {
        this.loadData(1)
    }

    loadData(page) {
        var self = this;
        orderApi.orderList(page, 10, self.state.keyword).then(function (res) {
            var _orders = res.responseContent.orders || [];
            var _total = res.responseContent.totalCount || 0;
            var _servTime = res.responseTime || Math.floor(new Date().getTime() / 1000)
            self.setState({
                orders: _orders,
                total: _total,
                serverTime:_servTime
            })
        })
    }

    onChangePage(page, pageSize) {
        this.setState({
            current: page
        })
        this.loadData(page)
    }

    changeText(e) {
        var val = e.target.value;
        this.setState({
            keyword: val
        })
    }

    render() {
        let { orders,
            total,
            current,
            keyword ,serverTime} = this.state;
        return (
            <React.Fragment>
                <div className="search-wrap">
                    <Form layout="inline">
                        <FormItem label="买家手机号或订单号：" >
                            <Input placeholder="请输入买家手机号或订单号" type="text" className="width200" value={keyword} onChange={(e) => { this.changeText(e) }} />
                        </FormItem>
                        <FormItem>
                            <Button
                                type="primary"
                                onClick={() => { this.loadData(1) }}>搜索 </Button>
                        </FormItem>
                    </Form>
                </div>
                {
                    orders.map(function (order) {
                        return <Distribution key={order.orderId} order={order} serverTime={serverTime}/>
                    })
                }


                <div className="pagination-wrap">
                    {
                        (orders && orders.length > 0) ? <Pagination className="pagination-main" defaultPageSize={10} current={current} total={total} onChange={(page, pageSize) => { this.onChangePage(page, pageSize) }} />
                            : <div  className="nodata">暂无数据</div>
                    }
                </div>
            </React.Fragment>
        );
    }
}