import React from 'react';
import './StockManage.less';

import storeWarnApi from '../../../api/storeApi'
import StockItem from '../../commonComponent/Stock/StockItem';
import EventBus from '../../../service/EventBus'
import { DataBusInstance } from '../../../service/databus'
export default class StockManage extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            storeList: []
        }
    }

    componentDidMount() {
        EventBus.onSingle('RELOAD_STOCK_LIST', this.reload.bind(this))
        this.reload();
    }

    reload() {
        var self = this;
        storeWarnApi.getWarningList().then(function (res) {
            var _storeList = res.responseContent || [];
            self.setState({
                storeList: _storeList
            })

            var cnt = _storeList.length;
            var old = DataBusInstance.getSessionKey();
            old['alertCount'] = cnt;
            DataBusInstance.setSessionKey(old)
            EventBus.emit('TOTAL_CHANGED', old)
        })
    }

    render() {
        let self = this;
        let { storeList } = self.state;
        return (
            <React.Fragment>
                {
                    (storeList && storeList.length > 0) ?
                        <div>
                            <div className='stock-table-header'>
                                <div className='stock-table-header-in'>
                                    <div className='stock-table-title'>商品名称</div>
                                    <div className='stock-table-title stock-font-center stock-title-width20'>规格</div>
                                    <div className='stock-table-title stock-font-center stock-title-width15'>库存数量</div>
                                    <div className='stock-table-title stock-font-center stock-title-width15'>库存预警值</div>
                                    <div className='stock-table-title stock-font-center stock-title-width15'>操作</div>
                                </div>
                            </div>
                            {
                                storeList && storeList.map(function (res) {
                                    return (
                                        <StockItem stock={res} key={res.goodsId}></StockItem>
                                    )
                                })
                            }
                        </div> : <div className="nodata">暂无数据</div>
                }
            </React.Fragment>

        );
    }
}