var EventBus = require('../service/EventBus');

import loginApi from '../api/loginApi'

import { DataBusInstance } from '../service/databus'

import Version from '../../../version'
export default class AlertTip {
  ws_url = Version().ws_url;
  key;
  constructor() {

  }

  createSocket(key, reconnect) {
    let self = this;
    self.key = key;
    this.Socket = new WebSocket(this.ws_url); // 建立 web socket 连接成功触发事件
    this.Socket.onopen = function (ws) {
      // 使用 send() 方法发送数据  
      try {
        var msg = { "method": "join", "key": key };
        self.Socket.send(JSON.stringify(msg))
      } catch (e) {
        console.error(e)
      }
    };

    // 接收服务端数据时触发事件
    this.Socket.onmessage = function (evt) {
      var received_msg = evt.data;
      var msg = JSON.parse(received_msg);
      if (msg.method == 'fromMsg') {
        self.resetNum(msg.data)
      } else if (msg.method == 'connection') {

      } else if (msg.method == 'login') {
        if (reconnect) {
          loginApi.count().then(function (res) {
            try {
              var datas = res.responseContent;
              var old = DataBusInstance.getSessionKey();
              Object.assign(old, datas);
              DataBusInstance.setSessionKey(old)
              EventBus.emit('TOTAL_CHANGED', old)
            } catch (e) { }
          })
        }
      }
    };

    // 断开 web socket 连接成功触发事件
    this.Socket.onclose = function (err) {      
      // var so = setTimeout(function () {
      //   clearTimeout(so)
      //   self.createSocket(self.key, true)
      // }, 3000)
    };

    this.Socket.onerror = function (err) {      
      // var so = setTimeout(function () {
      //   clearTimeout(so)
      //   self.createSocket(self.key, true)
      // }, 5000)
    };
  }

  /**
   *  *      *  "waitReceiveCount":0,
        "waitDeliveryCount":1,
        "waitGetCount":0,
        "orderCount":1,
        "waitRefundProccessCount":0,
        "waitRefundReceiveCount":14,
        "refundCount":14,
        "alertCount":0
   * @param {*} msg 
   */
  resetNum(msg) {

    if (msg.type == 101 || msg.type == 102 || msg.type == 106) {
      var old = DataBusInstance.getSessionKey();      
      old['waitReceiveCount'] += msg['waitReceiveCount']
      old['waitDeliveryCount'] += msg['waitDeliveryCount']
      old['waitGetCount'] += msg['waitGetCount']
      old['orderCount'] += msg['orderCount']
      old['waitRefundProccessCount'] += msg['waitRefundProccessCount']
      old['waitRefundReceiveCount'] += msg['waitRefundReceiveCount']
      old['refundCount'] += msg['refundCount']
      old['alertCount'] += msg['alertCount']
      DataBusInstance.setSessionKey(old)
      EventBus.emit('TOTAL_CHANGED', old)
      if (msg['waitReceiveCount'] > 0) {
        EventBus.emit('NEW_ORDER_TIP')
      }

      if (msg.params && msg.params['orderId']) {
        var orderId = msg.params['orderId'];
        EventBus.emit('RELOAD_ORDER_' + orderId)
      } else if (msg.params && msg.params['refundId']) {
        var refundId = msg.params['refundId'];
        EventBus.emit('RELOAD_REFUND_' + refundId)
      } else {
        EventBus.emit('RELOAD_STOCK_LIST')
      }
    } else if (msg.type == 107) {
      EventBus.emit('USER_LOGOUT')
    }
  }




}