<?php

namespace Redis\Db4;

/**
 * redis操作类
 */
class AbstractModel extends \Redis\AbstractModel {

    /**
     * 连接的库
     * 
     * @var int 
     */
    protected $_db = 4;

    public function find($id) {
        $result = $this->get($this->calcKey($id));


        if($this->is_serialized($result)){
            return unserialize($result);
        }
        return $result;
    }
    public function tableCacheGet($id){
        $result = $this->get($this->calcKey($id));
        return $result;
    }

    /**
     * 通过前缀获取单个对象
     * @param $id
     * @return bool|mixed|string
     */
    public function getByKeys($id){
        $str = $this->tableKeys($id);
        if($str){
            $str = $str[0];
            $result = $this->getNoPrefix($str);
            if($this->is_serialized($result)){
                return unserialize($result);
            }
            return $result;
        }else{
            return false;
        }
    }

    public function tableCacheSet($id,$data,$experio){
        $res=$this->set($this->calcKey($id), $data,$experio);
        return $res;
    }
    public function calcKey($id) {
        return $this->_tableName . self::DELIMITER . $id;
    }

    public function update($id, $data,$expire=0) {
        return $this->set($this->calcKey($id), serialize($data),$expire);
    }

    public function tableHSet($h,$key,$val,$experio=0){
        return $this->hset($this->calcKey($h),$key,$val,$experio);
    }

    public function tableHGet($h,$key){
        return $this->hget($this->calcKey($h),$key);
    }

    public function tableHMSet($h,$keysvalue,$experio=0){
        return $this->hmset($this->calcKey($h),$keysvalue,$experio);
    }

    public function tableHMGet($h,$keyvalues){
        return $this->hmget($this->calcKey($h),$keyvalues);
    }

    public function tableKeys($prekey){
        return $this->keys($this->calcKey($prekey));
    }
    public function tableHKeys($prekey){
        return $this->hkeys($this->calcKey($prekey));
    }
    public function tableDelAll($data){
        return $this->delAll($data);
    }

    public function tableHGAll($h){
        return $this->hGetAll($this->calcKey($h));
    }

    public function tableDel($h){
        return $this->del($this->calcKey($h));
    }

    public function tableSAddArray($h,array $value){
        return $this->sAddArray($this->calcKey($h),$value);
    }
    public function tableSAdd($h,$value){
        return $this->sadd($this->calcKey($h),$value);
    }
    public function tableSPop($h){
        return $this->sPop($this->calcKey($h));
    }
    public function tableSIsMember($h,$value){
        return $this->sIsMember($this->calcKey($h),$value);
    }
    public function tableSmembers($key) {
        return $this->smembers($this->calcKey($key));
    }
    public function tableKeyExists($h){
        return $this->exists($this->calcKey($h));
    }

    public function tableLPush($h,$value){
        return $this->lpush($this->calcKey($h),$value);
    }
    public function tableLPop($h){
        $res=$this->lpop($this->calcKey($h));
        return $res;
    }
    public function tableSRandMember($h,$count = null){
        return $this->sRandMember($this->calcKey($h),$count);
    }
    public function tableHIncrBy($h,$key,$keysvalue){
        return $this->hIncrBy($this->calcKey($h),$key,$keysvalue);
    }
    public function tableHExists($h,$key){
        return $this->hExists($this->calcKey($h),$key);
    }
    public function tableHDel($h,$key){
        return $this->hDel($this->calcKey($h),$key);
    }

    public function tableLRange($key,$start,$end){
        $res = $this->lrange($this->calcKey($key),$start,$end);
        return $res;
    }

}
