<?php
namespace Store;
/**
 * User: liuyuzhen
 * Date: 2018/10/18
 * Time: 17:34
 * Description:
 */

class StoreUtil {

    public function checkAddressInServiceAreaByStore($address,$store){
        $storeDao = \DAO\StoreModel::getInstance();
        //$store = $storeDao->get($storeId,false);
        $storeId = $store['store_id'];
        $inAreaFlag = false ;
        $qmStoreClassDao = \DAO\QmStoreClassModel::getInstance();
        $qmClassCon['store_id'] = $storeId;
        $qmClassCon['is_charged'] = 1;
        $qmClassCon['class_style'] = 2;
        $qmSignScopeList = \Our\RedisHelper::cachedFunction(\Redis\Db6\QmStoreClassRedisModel::getInstance(),array(&$qmStoreClassDao, 'selectByWhere'),array($qmClassCon,'sign_scope'),\Our\ApiConst::oneHour,array($storeId));
        if($qmSignScopeList){
            foreach($qmSignScopeList as $qmSignScope){
                if($qmSignScope['sign_scope']){
                    $inAreaFlag = \Our\CommonExtension::locationInArea($address['lat'],$address['lng'],$qmSignScope['sign_scope']);
                    if($inAreaFlag){
                        return true;
                    }
                }
            }
        }
        if(!$store['store_sales_scope']){
            return false;
        }
        $inAreaFlag = \Our\CommonExtension::locationInArea($address['lat'],$address['lng'],$store['store_sales_scope']);
        return $inAreaFlag;
    }


    public function checkAddressInServiceArea($address,$storeId){
        $storeDao = \DAO\StoreModel::getInstance();
        $store = $storeDao->get($storeId,false);
        $inAreaFlag = false ;
        $qmStoreClassDao = \DAO\QmStoreClassModel::getInstance();
        $qmClassCon['store_id'] = $storeId;
        $qmClassCon['is_charged'] = 1;
        $qmClassCon['class_style'] = 2;
        $qmSignScopeList = \Our\RedisHelper::cachedFunction(\Redis\Db6\QmStoreClassRedisModel::getInstance(),array(&$qmStoreClassDao, 'selectByWhere'),array($qmClassCon,'sign_scope'),\Our\ApiConst::oneHour,array($storeId));
        if($qmSignScopeList){
            foreach($qmSignScopeList as $qmSignScope){
                if($qmSignScope['sign_scope']){
                    $inAreaFlag = \Our\CommonExtension::locationInArea($address['lat'],$address['lng'],$qmSignScope['sign_scope']);
                    if($inAreaFlag){
                        return true;
                    }
                }
            }
        }
        if(!$store['store_sales_scope']){
            return false;
        }
        $inAreaFlag = \Our\CommonExtension::locationInArea($address['lat'],$address['lng'],$store['store_sales_scope']);
        return $inAreaFlag;
    }

    /**
     * 经纬度是否在店铺地址范围内
     * @param $lat
     * @param $lng
     * @param $storeId
     * @return bool
     */
    public function checkLocationInServiceArea($lat,$lng,$storeId){
        return self::checkAddressInServiceArea(array('lat'=>$lat,'lng'=>$lng),$storeId);
    }

    /**
     * 类实例
     *
     */
    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}