<?php

namespace DAO;

/**
 * 用户数据层
 */
class DeliveryFormulaModel extends \DAO\AbstractModel {



    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_delivery_formula';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';
    public function init(){

    }
    public function getOne($field,$where){
        $this->setDb($this->dbName);
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchOne();
    }



    public function getDeliveryFormulaByDistince($storeId,$distince,$deliveryFormula){
        if(!$deliveryFormula){
            return false;
        }
        /*$deliveryFormula['state'] == 1 ? $formula = unserialize($deliveryFormula['formula']) : $formula = unserialize($deliveryFormula['simple_formula']);
        if($deliveryFormula['state'] == 1){
            ksort($formula);
            foreach($formula as $key=>$temp){
                if($key*1000>=$distince){
                    return $formula[$key];
                }
            }
        }else{
            foreach($formula as $key=>$temp){
                if($key*1000>=$distince){
                    return $formula[$key];
                }
            }
        }*/
        $formula = unserialize($deliveryFormula['simple_formula']);
        foreach($formula as $key=>$temp){
            if($key*1000>=$distince){
                return $formula[$key];
            }
        }
    }


    /**
     * 获取店铺自提时间段列表
     * @param $store
     * @return array
     */
    public function getBuyerFormulaForCart($store){
        $currentTime = TIMESTAMP;
        $time = date('Y-m-d', $currentTime);
        if ($store['store_start_time'] && $store['store_close_time']) {
            $todayStartTime = strtotime($time . ' ' . $store['store_start_time']);
            $todayEndTime = strtotime($time . ' ' . $store['store_close_time']);
            if($todayEndTime<=$todayStartTime){
                $todayEndTime += \Our\ApiConst::oneDaySecond;
            }
        } else {
            $todayStartTime = $time + \Our\ApiConst::deliveryStartTime;
            $todayEndTime = $time + \Our\ApiConst::deliveryEndTime;
        }
        if($currentTime<$todayStartTime){
            $currentTime = $todayStartTime;
        }
        $return=array();
        $todayUnixTime = mktime(0,0,0,date('m'),date('d'),date('Y'));
        $todayList = $this->getBuyerFormulaList($currentTime,$todayEndTime,\Our\ApiConst::one);
        $isDefault = \Our\ApiConst::zero;
        if($todayList){
            $return = array_merge($return,$todayList);
        }else{
            $isDefault = \Our\ApiConst::one;
        }
        $tommorowStartTime = $todayStartTime + \Our\ApiConst::oneDaySecond;
        $tommorowEndTime = $todayEndTime + \Our\ApiConst::oneDaySecond;
        $tromorrowList = $this->getBuyerFormulaList($tommorowStartTime,$tommorowEndTime,$isDefault);
        if($tromorrowList){
            $return = array_merge($return,$tromorrowList);
        }
        $isDefault = \Our\ApiConst::zero;
        if(!$return){
            $isDefault = \Our\ApiConst::one;
        }
        $nextStartTime = $todayStartTime + \Our\ApiConst::oneDaySecond*2;
        $nextEndTime = $todayEndTime + \Our\ApiConst::oneDaySecond*2;
        if($nextEndTime>($todayUnixTime+\Our\ApiConst::oneDaySecond*3)){
            $nextEndTime = ($todayUnixTime+\Our\ApiConst::oneDaySecond*3);
        }

        $nextList = $this->getBuyerFormulaList($nextStartTime,$nextEndTime,$isDefault);
        if($nextList){
            $return = array_merge($return,$nextList);
        }
        if($return){
            $newReturn = array();
            foreach($return as $val){
                $keyTemp= strtotime(date('Y-m-d',$val[0]['time']));
                if(isset($newReturn[$keyTemp])){
                    $newReturn[$keyTemp] = array_merge($newReturn[$keyTemp],$val);
                }else{
                    $newReturn[$keyTemp]=$val;
                }
            }
            $returnList = array();
            foreach($newReturn as $key=>$value){
                $dayList = array();
                $dayList['time']= strtotime(date('Y-m-d',$value[0]['time']));
                $dayList['list']= $value;
                $returnList[] = $dayList;
            }
            return array('timeList'=>$returnList,'default'=>\Our\ApiConst::zero);
        }
        return $return;
    }

    public function delDeliverFormulaByStoreId($storeId){
        return \Our\RedisHelper::delCachedFunction(\Redis\Db6\DeliveryFormulaRedisModel::getInstance(),array(&$this, 'getOne'),array(),\Our\ApiConst::sevenDaySecond,array($storeId));
    }

    /**
     * 新的配送公式
     * @param $store
     * @param $storeCarts
     * @param $distance
     * @param bool $deliveryFreeFlag
     * @return array
     * @throws \Our\Exception
     */
    public function getDeliveryFormulaForCartNew($store,$storeCarts,$distance,$deliveryFreeFlag=false,$checkFlag = false){
        $delivery_template_ids = array_unique(array_column($storeCarts['storeCarts'],'delivery_template_id'));
        $deliveryFormula = \Our\RedisHelper::cachedFunction(\Redis\Db6\DeliveryFormulaRedisModel::getInstance(),array(&$this, 'getOne'),array('*',array('store_id'=>$store['store_id'])),\Our\ApiConst::sevenDaySecond,array($store['store_id']));
        if(!$deliveryFormula){
            return false;
        }
        $formulaList = unserialize($deliveryFormula['formula']);
        $fullFormulaList = array_column($formulaList, 'list', 'template_id');
        $myFormulaList =array_intersect_key($fullFormulaList,array_flip($delivery_template_ids));
        $distanceFormulaList = array();
        foreach($myFormulaList as $tempFormulaList){
            foreach($tempFormulaList as $tempFormula){
                if($tempFormula['distance']=='other'){
                    $distanceFormulaList[] = $tempFormula;
                    break;
                }else{
                    if($distance<(intval($tempFormula['distance'])*\Our\ApiConst::thousand)){
                        $distanceFormulaList[] = $tempFormula;
                        break;
                    }
                }
            }
        }
        $formula = array();

        $formula['half'] = max(array_column($distanceFormulaList,'half'));
        $formula['one'] = max(array_column($distanceFormulaList,'one'));
        $formula['two'] = max(array_column($distanceFormulaList,'two'));
        $formula['day'] = max(array_column($distanceFormulaList,'day'));
        $formula['other'] = max(array_column($distanceFormulaList,'other'));

        foreach($distanceFormulaList as &$tempFormuala){
            if($formula['half']){
                if(!$tempFormuala['half']){
                    $tempFormuala['half'] = $tempFormuala['one']?$tempFormuala['one']:($tempFormuala['two']?$tempFormuala['two']:($tempFormuala['day']?$tempFormuala['day']:$tempFormuala['other']));
                }
            }
            if($formula['one']){
                if(!$tempFormuala['one']){
                    $tempFormuala['one'] = $tempFormuala['two']?$tempFormuala['two']:($tempFormuala['day']?$tempFormuala['day']:$tempFormuala['other']);
                }
            }
            if($formula['two']){
                if(!$tempFormuala['two']){
                    $tempFormuala['two'] = $tempFormuala['day']?$tempFormuala['day']:$tempFormuala['other'];
                }
            }
            if($formula['day']){
                if(!$tempFormuala['day']){
                    $tempFormuala['day'] = $tempFormuala['other'];
                }
            }
        }
        $formula['half'] = max(array_column($distanceFormulaList,'half'));
        $formula['one'] = max(array_column($distanceFormulaList,'one'));
        $formula['two'] = max(array_column($distanceFormulaList,'two'));
        $formula['day'] = max(array_column($distanceFormulaList,'day'));
        $currentTime =TIMESTAMP;

        $time = date('Y-m-d',$currentTime);
        $todayUnixTime = strtotime($time);
        if($store['store_dis_sta_time']&&$store['store_dis_end_time']){
            $todayStartTime = strtotime($time.' '.$store['store_dis_sta_time']);
            $todayEndTime = strtotime($time.' '.$store['store_dis_end_time']);
            if($todayEndTime<=$todayStartTime){
                $todayEndTime += \Our\ApiConst::oneDaySecond;
            }
        }else{
            $todayStartTime = $time+\Our\ApiConst::deliveryStartTime;
            $todayEndTime = $time+\Our\ApiConst::deliveryEndTime;
        }
        $todayInterval = 0;
        if($formula['half']){
            $currentMinute = date('i',$currentTime);
            $tenMinute =10;
            $forthMinute = 40;
            if($checkFlag){
                $tenMinute =15;
                $forthMinute = 45;
            }
            if($currentMinute<=$tenMinute){
                $currentTime = mktime(date('H',$currentTime),0,0,date('m',$currentTime),date('d',$currentTime),date('Y',$currentTime));
            }else if($currentMinute>$tenMinute&&$currentMinute<=$forthMinute){
                $currentTime = mktime(date('H',$currentTime),30,0,date('m',$currentTime),date('d',$currentTime),date('Y',$currentTime));
            }else if($currentMinute>$forthMinute){
                $currentTime = mktime(date('H',$currentTime),60,0,date('m',$currentTime),date('d',$currentTime),date('Y',$currentTime));
            }
        }else if($formula['one']){
            $todayInterval = \Our\ApiConst::halfHour;
        }else if($formula['two']){
            $todayInterval = \Our\ApiConst::oneHour;
        }else if($formula['day']){
            $todayInterval = \Our\ApiConst::oneHour*2 ;
        }else{
            $todayInterval = \Our\ApiConst::oneDaySecond;
        }

        $currentTime = $currentTime + $todayInterval;
        $defaultFee = $formula['half']?$formula['half']:($formula['one']?$formula['one']:($formula['two']?$formula['two']:($formula['day']?$formula['day']:$formula['other'])));
        $defaultFee = $defaultFee*\Our\ApiConst::hundred;
        $return = array();
        $tommorowDefault = \Our\ApiConst::zero;
        if($currentTime<$todayEndTime){
            if($todayStartTime>$currentTime){
                $currentTime = $todayStartTime;
            }
            $formulaList = $this->getTodayFormulaList($currentTime,$todayEndTime,$todayInterval,$formula,$deliveryFreeFlag);
            if(!$formulaList){
                $tommorowDefault = \Our\ApiConst::one;
            }else{
                $return = array_merge($return,$formulaList);
            }
        }else{
            $tommorowDefault = \Our\ApiConst::one;
        }

        $tommorowStartTime = $todayStartTime + \Our\ApiConst::oneDaySecond;
        $tommorowEndTime = $todayEndTime + \Our\ApiConst::oneDaySecond;
        $tromorrowList = $this->getOtherDayFormulaList($tommorowStartTime,$tommorowEndTime,$formula['other'],$deliveryFreeFlag,$tommorowDefault);
        if($tromorrowList){
            $return = array_merge($return,$tromorrowList);
        }
        $nextStartTime = $todayStartTime + \Our\ApiConst::oneDaySecond*2;
        $nextEndTime = $todayEndTime + \Our\ApiConst::oneDaySecond*2;
        if($nextEndTime>$todayUnixTime + \Our\ApiConst::oneDaySecond*3){
            $nextEndTime = $todayUnixTime + \Our\ApiConst::oneDaySecond*3;
        }
        $isDefault = \Our\ApiConst::zero;
        if(!($return)){
            $isDefault = \Our\ApiConst::one;
        }
        $nextList = $this->getOtherDayFormulaList($nextStartTime,$nextEndTime,$formula['other'],$deliveryFreeFlag,$isDefault);
        if($nextList){
            $return = array_merge($return,$nextList);
        }
        if($return){
            $newReturn = array();
            foreach($return as $val){
                $keyTemp= strtotime(date('Y-m-d',$val[0]['time']));
                if(isset($newReturn[$keyTemp])){
                    $newReturn[$keyTemp] = array_merge($newReturn[$keyTemp],$val);
                }else{
                    $newReturn[$keyTemp]=$val;
                }
            }
            $returnList = array();
            foreach($newReturn as $key=>$value){
                $dayList = array();
                $dayList['time']= strtotime(date('Y-m-d',$value[0]['time']));
                $dayList['list']= $value;
                $returnList[] = $dayList;
            }
            return array('timeList'=>$returnList,'default'=>$defaultFee);
        }
        return $return;

    }

    public function getTodayFormulaList($beginTime,$endTime,$todayInterval,$formulaPrice,$deliveryFreeFlag){
        $formulaList = array();
        $time = TIMESTAMP;
        $initMinute = intval(date('i',$beginTime));
        if($initMinute==0||$initMinute==30){
            $startTime = $beginTime;
        }else{
            if($initMinute<30){
                $startTime = mktime(date('H',$beginTime),30,0,date('m',$beginTime),date('d',$beginTime),date('Y',$beginTime));
            }else if($initMinute<60){
                $startTime = mktime(date('H',$beginTime),60,0,date('m',$beginTime),date('d',$beginTime),date('Y',$beginTime));
            }
        }
        if($startTime+\Our\ApiConst::halfHour<$endTime){
            $interval =$todayInterval;
            for($i=$startTime;$i<$endTime;$i = $i+(\Our\ApiConst::halfHour)){
                $interval += \Our\ApiConst::halfHour;
                $temp = array();
                $temp['time'] = $i;
                $temp['isDefault'] = \Our\ApiConst::zero;
                if($interval==\Our\ApiConst::halfHour*1){//半小时内的价格
                    $temp['price'] = $formulaPrice['half'];
                    $temp['isDefault'] = \Our\ApiConst::one;
                }else if($interval<=\Our\ApiConst::halfHour*2){
                    $temp['price'] = $formulaPrice['one'];
                }else if($interval<=\Our\ApiConst::halfHour*4){
                    $temp['price'] = $formulaPrice['two'];
                }else{
                    $temp['price'] = $formulaPrice['day'];
                }
                if($deliveryFreeFlag){
                    $temp['price'] = \Our\ApiConst::zero;
                }
                $index = strtotime(date('Y-m-d',$i));
                $temp['price'] = $temp['price']?($temp['price']*\Our\ApiConst::hundred):\Our\ApiConst::zero;
                $formulaList[$index][] = $temp;
            }
        }
        return $formulaList;
    }

    public function getOtherDayFormulaList($beginTime,$endTime,$price,$deliveryFreeFlag,$isDefault = \Our\ApiConst::zero){
        $formulaList = array();
        $initMinute = intval(date('i',$beginTime));
        if($initMinute==0||$initMinute==30){
            $startTime = $beginTime;
        }else{
            if($initMinute<30){
                $startTime = mktime(date('H',$beginTime),30,0,date('m',$beginTime),date('d',$beginTime),date('Y',$beginTime));
            }else if($initMinute<60){
                $startTime = mktime(date('H',$beginTime),60,0,date('m',$beginTime),date('d',$beginTime),date('Y',$beginTime));
            }
        }
        if($startTime+\Our\ApiConst::halfHour<$endTime){
            for($i=$startTime;$i<$endTime;$i = $i+(\Our\ApiConst::halfHour)){
                $temp = array();
                $temp['time'] = $i;
                $temp['price'] = $price?($price*\Our\ApiConst::hundred):\Our\ApiConst::zero;
                if($deliveryFreeFlag){
                    $temp['price'] = \Our\ApiConst::zero;
                }
                $temp['isDefault'] = $isDefault;
                $isDefault = \Our\ApiConst::zero;
                $index = strtotime(date('Y-m-d',$i));
                $formulaList[$index][] = $temp;
            }
        }
        return $formulaList;
    }


    /**
     * 获取自提时间段
     * @param $beginTime
     * @param $endTime
     * @param int $isDefault
     * @return array
     */
    public function getBuyerFormulaList($beginTime,$endTime,$isDefault = \Our\ApiConst::zero){
        $formulaList = array();
        $initMinute = intval(date('i',$beginTime));
        if($initMinute==0||$initMinute==30){
            $startTime = $beginTime;
        }else{
            if($initMinute<10){
                $startTime = mktime(date('H',$beginTime),30,0,date('m',$beginTime),date('d',$beginTime),date('Y',$beginTime));
            }else if($initMinute<60){
                $startTime = mktime(date('H',$beginTime),60,0,date('m',$beginTime),date('d',$beginTime),date('Y',$beginTime));
            }
        }
        if($startTime+\Our\ApiConst::halfHour<$endTime){
            for($i=$startTime;$i<$endTime;$i = $i+(\Our\ApiConst::halfHour)){
                $temp = array();
                $temp['time'] = $i;
                $temp['isDefault'] = $isDefault;
                $temp['price'] = \Our\ApiConst::zero;
                $isDefault = \Our\ApiConst::zero;
                $index = strtotime(date('Y-m-d',$i));
                $formulaList[$index][] = $temp;
            }
        }
        return $formulaList;
    }


    public function getDeliveryFormulaForCart($store,$distance,$deliveryFreeFlag=false){
        $deliveryFormula = \Our\RedisHelper::cachedFunction(\Redis\Db6\DeliveryFormulaRedisModel::getInstance(),array(&$this, 'getOne'),array('*',array('store_id'=>$store['store_id'])),\Our\ApiConst::sevenDaySecond,array($store['store_id']));
        if(!$deliveryFormula){
            return false;
        }
        //$deliveryFormula['state'] == \Our\ApiConst::one ? $formula = unserialize($deliveryFormula['formula']) : $formula = unserialize($deliveryFormula['simple_formula']);
        $formula = unserialize($deliveryFormula['simple_formula']);
        ksort($formula);
        foreach ($formula as $k=>$v){
            if($k*1000 >= $distance){
                $choosedData = $v;
                //$choosedData['deliver_distance'] = $k;
                break;
            }
        }
        if(!isset($choosedData)){
            return false;
        }
        $deliveryIntval = intval($store['delivery_interval'])>0?intval($store['delivery_interval']):\Our\ApiConst::defaultDeliveryInterval;
        $time = date('Y-m-d',time());
        $todayUnixTime = strtotime($time);
        if($store['store_dis_sta_time']&&$store['store_dis_end_time']){
            $todayStartTime = strtotime($time.' '.$store['store_dis_sta_time']);
            $todayEndTime = strtotime($time.' '.$store['store_dis_end_time']);
        }else{
            $todayStartTime = $time+\Our\ApiConst::deliveryStartTime;
            $todayEndTime = $time+\Our\ApiConst::deliveryEndTime;
        }
        $tommorowStartTime = $todayStartTime + \Our\ApiConst::oneDaySecond;
        $tommorowEndTime = $todayEndTime + \Our\ApiConst::oneDaySecond;
        /*if($deliveryFormula['state'] == \Our\ApiConst::one) {
            $returnData = $this->getCommonFormula($choosedData,$todayStartTime,$todayEndTime,$tommorowStartTime,$tommorowEndTime,$deliveryIntval);
        }else{
            $returnData = $this->getSimpleFormula($choosedData,$todayStartTime,$todayEndTime,$tommorowStartTime,$tommorowEndTime,$deliveryIntval);
        }*/
        $returnData = $this->getSimpleFormula($choosedData,$todayStartTime,$todayEndTime,$tommorowStartTime,$tommorowEndTime,$deliveryIntval);
        if($deliveryFreeFlag&&$returnData){
            $aRplaceMent=array_fill(0,count($returnData),array('price'=>0));
            $returnData=array_replace_recursive($returnData,$aRplaceMent);
        }
        return $returnData;
    }

    /**
     * 获取简易版配送公式
     * @param $choosedData
     * @param $todayStartTime
     * @param $todayEndTime
     * @param $tommorowStartTime
     * @param $tommorowEndTime
     * @param $deliveryIntval
     * @return array
     */
    public function getSimpleFormula($choosedData,$todayStartTime,$todayEndTime,$tommorowStartTime,$tommorowEndTime,$deliveryIntval){
        $currentTime = time();
        $minTime = $choosedData[0]['time']*\Our\ApiConst::oneMinute;
        $minFee =  $choosedData[count($choosedData)-1]['price']*\Our\ApiConst::hundred;
        ksort($choosedData);
        if($currentTime<$todayStartTime){
            $myCurrentStartTime = $todayStartTime;
            $myCurrentEndTime = $todayEndTime;
        }else if(($currentTime+$minTime)>$todayEndTime){//今天无法配送的情况下直接返回明天的配送时间
            $tommorowData = $this->getTomorrowFormulaList($tommorowStartTime,$tommorowEndTime,\Our\ApiConst::oneHour,$minFee,$currentTime);
            $returnData = $tommorowData;
            ksort($returnData);
            foreach($returnData as &$data){
                $data['isDefault'] = \Our\ApiConst::one;
                break;
            }
            return $returnData;
        }else{
            $myCurrentStartTime = $currentTime;
            $myCurrentEndTime = $todayEndTime;
        }
        $tommorowData = $this->getTomorrowFormulaList($tommorowStartTime,$tommorowEndTime,\Our\ApiConst::oneHour,$minFee,$myCurrentStartTime);
        $returnData = array();
        ksort($choosedData);
        $expriseStartTime = \Our\ApiConst::zero;
        //var_dump($choosedData);
        foreach($choosedData as $key=>$temp){
            $tempData = array();
            $expriseStartTime = $myCurrentStartTime+ $temp['time']*\Our\ApiConst::oneMinute;
            if($expriseStartTime<=$myCurrentEndTime){
                $tempData['interval'] = $temp['time']*\Our\ApiConst::oneMinute;
                $tempData['time'] = $myCurrentStartTime + $tempData['interval'];
                $tempData['price'] = $temp['price']*\Our\ApiConst::hundred;
                if($key==2){
                    $tempData['isDefault'] = \Our\ApiConst::one;
                }else{
                    $tempData['isDefault'] = \Our\ApiConst::zero;
                }
                $returnData[] = $tempData;
            }else{
                break;
            }
        }
        $expriseStartTime += $deliveryIntval*\Our\ApiConst::oneMinute;
        if($expriseStartTime<$todayEndTime){
            $expriseData = $this->getTomorrowFormulaList($expriseStartTime,$todayEndTime,$deliveryIntval*\Our\ApiConst::oneMinute,$minFee,$myCurrentStartTime);
            if($expriseData){
                $returnData = array_merge($expriseData,$returnData);
            }
        }
        if($returnData){
            $returnData = array_merge($returnData,$tommorowData);
        }else{
            $returnData = $tommorowData;
        }
        foreach($returnData as $key => $delivery){
            $time[$key] = $delivery['time'];
        }
        array_multisort($time, SORT_ASC, $returnData);
        return $returnData;
    }


    /**
     * 获取常规版配送公式
     * @param $formula
     * @param $todayStartTime
     * @param $todayEndTime
     * @param $tommorowStartTime
     * @param $tommorowEndTime
     * @param $deliveryIntval
     * @return array
     */
    public function getCommonFormula($formula,$todayStartTime,$todayEndTime,$tommorowStartTime,$tommorowEndTime,$deliveryIntval){
        $returnData = array();
        $currentTime = time();
        $minTime = $formula['min_time'] * \Our\ApiConst::oneMinute;
        $minFee = $formula['min_price'] * \Our\ApiConst::hundred;
        $defaultFee = $formula['default_price'] * \Our\ApiConst::hundred;
        if($currentTime<$todayStartTime){
            $myCurrentStartTime = $todayStartTime;
            $myCurrentEndTime = $todayEndTime;
        }else if(($currentTime+$minTime)>$todayEndTime){//今天无法配送的情况下直接返回明天的配送时间
            $tommorowData = $this->getTomorrowFormulaList($tommorowStartTime,$tommorowEndTime,\Our\ApiConst::oneHour,$minFee,$currentTime);
            $returnData = $tommorowData;
            ksort($returnData);
            foreach($returnData as &$data){
                $data['isDefault'] = \Our\ApiConst::one;
                break;
            }
            return $returnData;
        }else{
            $myCurrentStartTime = $currentTime;
            $myCurrentEndTime = $todayEndTime;
        }
        $tommorowData = $this->getTomorrowFormulaList($tommorowStartTime,$tommorowEndTime,\Our\ApiConst::oneHour,$minFee,$myCurrentStartTime);
        $defalutTime = $myCurrentStartTime + $formula['default_time']*\Our\ApiConst::oneMinute;
        $defalutData['time'] = $defalutTime;
        $defalutData['interval'] = $formula['default_time']*\Our\ApiConst::oneMinute;
        $defalutData['price'] = $formula['default_price']*\Our\ApiConst::hundred;
        $defalutData['isDefault'] = \Our\ApiConst::one;
        $returnData[] = $defalutData;
        $earlierTotalPrice = ($formula['max_price']-$formula['default_price'])*\Our\ApiConst::hundred;
        $earlierTimeIntervalNum  = ($formula['default_time'] - $formula['min_time'])/$formula['interval_time'];
        $earlierPrice = round($earlierTotalPrice/$earlierTimeIntervalNum);//更早送达的单个时间间隔单价
        $intervalTimeInSecond = $formula['interval_time']* \Our\ApiConst::oneMinute;
        for($i = \Our\ApiConst::one;$i<=$earlierTimeIntervalNum;$i++){
            if(($defalutTime - $intervalTimeInSecond*$i)>$myCurrentStartTime){
                $temp = array();
                $temp['time'] = $defalutTime - $intervalTimeInSecond*$i;
                $temp['interval']=$temp['time'] - $currentTime;
                $temp['price'] = $defaultFee + $earlierPrice*$i;
                $temp['isDefault'] = \Our\ApiConst::zero;
                $returnData[] =$temp;
            }
        }
        $laterTotalPrice = ($formula['default_price']-$formula['min_price'])*\Our\ApiConst::hundred;
        $laterTimeIntervalNum  = ($formula['max_time']-$formula['default_time'] )/$formula['interval_time'];
        $laterPrice = round($laterTotalPrice/$laterTimeIntervalNum);//更早送达的单个时间间隔单价
        $intervalTimeInSecond = $formula['interval_time']* \Our\ApiConst::oneMinute;
        $maxLastTime = \Our\ApiConst::zero;
        for($j = \Our\ApiConst::one;$j<=$laterTimeIntervalNum;$j++){
            if(($defalutTime + $intervalTimeInSecond*$j)<$myCurrentEndTime){
                $temp = array();
                $maxLastTime = $defalutTime + $intervalTimeInSecond*$j;
                $temp['interval']=$maxLastTime-$currentTime;
                $temp['time'] = $maxLastTime;
                $temp['price'] =  $defaultFee- $laterPrice*$j;
                $temp['isDefault'] = \Our\ApiConst::zero;
                $returnData[] =$temp;
            }
        }
        if($maxLastTime+$deliveryIntval*\Our\ApiConst::oneMinute<$myCurrentEndTime){//超过最大配送时间之后的配送
            $otherReturnData = $this->getTomorrowFormulaList($maxLastTime,$myCurrentEndTime,\Our\ApiConst::oneHour,$minFee,$currentTime);
            if($otherReturnData){
                $returnData = array_merge($returnData,$otherReturnData);
            }
        }
        $returnData = array_merge($returnData,$tommorowData);
        foreach($returnData as $key => $delivery){
            $time[$key] = $delivery['time'];
        }
        array_multisort($time, SORT_ASC, $returnData);
        return $returnData;
    }

    /**
     * 获取超出时间配送公式
     * @param $tommorowStartTime
     * @param $tommorowEndTime
     * @param $deliveryIntval
     * @param $defaultDeliveryMoney
     */
    public function getTomorrowFormulaList($tommorowStartTime,$tommorowEndTime,$deliveryIntval,$defaultDeliveryMoney,$currentTime){
        $return = array();
        for($i=$tommorowStartTime;$i<$tommorowEndTime;$i = $i+($deliveryIntval)){
            $temp = array();
            $temp['time'] = $i;
            $temp['interval'] = $i-$currentTime;
            $temp['price'] = $defaultDeliveryMoney;
            $temp['isDefault'] = \Our\ApiConst::zero;
            $return[] = $temp;
        }
        return $return;
    }


    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance($dbName = \Our\DbNameConst::salveDBConnectName) {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

}
