<?php
namespace DAO\Goods;
/**
 * User: liuyuzhen
 * Date: 2018/5/31
 * Time: 14:53
 * Description:
 */
class StoreTopSaleGoodsModel extends \DAO\AbstractModel{

    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_store_top_sale_goods';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';

    public function init()
    {

    }

    public function getList($where){
        $this->setDb();
        return $this->db->select('goods_commonid as goodsCommonId,goods_name as goodsName,goods_image as goodsImage,goods_score as evalScore')->from($this->_tableName)->where($where)->fetchAll();
    }

    /**
     * 获取缓存中店铺销量前三的商品列表
     * @param $where array 店铺id数组
     * @return array|bool
     */
    public function getGoodsList($storeIds)    {
        $storeTopSaleGoodsRedis = \Redis\Db4\StoreTopSaleGoodsRedisModel::getInstance();
        $orderGoods = array();
        if($storeIds) {

            foreach ($storeIds as $storeId) {
                $storeGoods = $storeTopSaleGoodsRedis->find($storeId);
                if ($storeGoods) {
                    $orderGoods = empty($orderGoods)?$storeGoods:array_merge($orderGoods, $storeGoods);
                }else{
                    $singleStoreGoods = $this->getList(array('store_id'=>$storeId));
                    if($singleStoreGoods){
                        $ordesGoods = empty($orderGoods)?$singleStoreGoods:array_merge($orderGoods,$singleStoreGoods);
                        $storeTopSaleGoodsRedis->update($storeId,$singleStoreGoods);
                    }
                }
            }
        }
        if ($orderGoods) {
            foreach($orderGoods as &$goods){
                $goods['goodsImage'] = \Our\ImageUtil::getGoodsImgUrl($goods['goodsImage']);
            }
            return $orderGoods;
        }
        return false;
    }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}