<?php
namespace DAO;
/**
 * User: liuyuzhen
 * Date: 2018/5/29
 * Time: 10:33
 * Description:
 */
class QmStoreClassModel extends \DAO\AbstractModel{
    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_qm_store_class';

    protected $_tableNameSign = 'han_sign_store_class_view';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';

    public function init(){
        //$this->setDb();
    }


    public function selectByWhere($where = null,$field = '*',$limit=false){
        $this->setDb();
        if(is_array($where)){
            $where = $this->db->getSqlWhereByArray($where);
        }
        if($limit){
            $result = $this->db->select($field)->from($this->_tableName)->where($where)->limit($limit[0],$limit[1])->fetchAll();
        }else{
            $result = $this->db->select($field)->from($this->_tableName)->where($where)->fetchAll();
        }
        return $result;
    }

    public function delSignScopeCache($storeId){
        $result = \Our\RedisHelper::delCachedFunction(\Redis\Db6\QmStoreClassRedisModel::getInstance(),array(&$this, 'selectByWhere'),array(),array($storeId));
        return $result;
    }


    /**
     * 一级分类对应有效的店铺
     * @param $gcId 一级分类
     * @return array|bool
     * @throws \Our\Exception
     */
    public function getStoreIdsByWhere($gcId){
        $where =' gc_parent_id ='.$gcId.' and is_charged = 1';
        $field = 'distinct(store_id) as store_id';
        $storeIdList = \Our\RedisHelper::cachedFunction(\Redis\Db6\QmStoreClassRedisModel::getInstance(),array(&$this, 'selectByWhere'),array($where,$field),\Our\ApiConst::oneHour,array($gcId));
        if($storeIdList){
            foreach($storeIdList as $store){
                $storeIds[] = $store['store_id'];
            }
            return $storeIds;
        }
        return false;
    }


    /**
     * 获取店铺可经营的电偶分类信息
     * @param $storeId
     * @param string $field
     * @return mixed
     * @throws \Our\Exception
     */
    public function getStoreOnlineParentGoodsClasses($storeId,$field=" distinct(gc_parent_id) as gc_id"){
        $where = ' store_id = '.$storeId.' and is_charged = 1';
        $list = \Our\RedisHelper::cachedFunction(\Redis\Db6\QmStoreClassRedisModel::getInstance(),array(&$this, 'selectByWhere'),array($where,$field),\Our\ApiConst::oneHour,array($storeId));
        return $list;
    }

    /**
     * 类实例
     */
    private static $_instance = null;

    /**
     * 获取类实例
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    public function getStoreClasses($where, $field = '*'){
        $this->setDb();
        $result = $this->db->select($field)->from($this->_tableName)->where($where)->fetchAll();
        return $result;
    }

    public function getStoreSignClasses($where,$field = "*"){
        $this->setDb();
        if(is_array($where)){
            $where = $this->db->getSqlWhereByArray($where);
        }
        $result = $this->db->select($field)->from($this->_tableNameSign)->where($where)->fetchAll();
        return $result;
    }


    /**
     * 删除签约店铺缓存
     * @param $cityCode
     * @throws \Our\Exception
     */
    public function delStoreSignClassesCache($cityCode=false,$storeId=false){
        if($cityCode){
            \Our\RedisHelper::delCachedFunction(\Redis\Db6\QmStoreClassRedisModel::getInstance(), array(&$this, 'getStoreSignClasses'),array(),array($cityCode));
        }
        if($storeId){
            \Our\RedisHelper::delCachedFunction(\Redis\Db6\QmStoreClassRedisModel::getInstance(), array(&$this, 'getStoreSignClasses'),array(),array('store'.$storeId));
        }
    }

    /**
     * 删除签约店铺缓存
     * @param $cityCode
     * @throws \Our\Exception
     */
    public function delStoreClassesCache($cityCode){
        \Our\RedisHelper::delCachedFunction(\Redis\Db6\QmStoreClassRedisModel::getInstance(), array(&$this, 'getStoreClasses'),array(),array($cityCode));
    }


    public function update($data,$where){

        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $result=$this->db->update($this->_tableName)->rows($data)->where($where)->execute();
        return $result;
    }
}