<?php

namespace DAO;


class SaleActivityModel extends \DAO\AbstractModel {



    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_sale_activity';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'sale_act_id';
    public function init(){

    }

    public function getOne($where,$field){
        $this->setDb();
        return $this->db->from($this->_tableName)->select($field)->where($where)->fetchOne();
    }
    public function getActList($where,$field) {
        $this->setDb();
        return $this->db->from($this->_tableName)->select($field)->where($where)->fetchAll();
    }
    public function getActByArr($saleActArr){
        $actList = [];
        foreach ($saleActArr as $k=>$v) {
            $act = \Redis\Db1\SaleOrderRedisModel::getInstance()->tableHGet('orderGoods_'.$k,$v);
            if($act){
                unset($saleActArr[$k]);
                $act =  unserialize($act);
                $actList[$act['sale_act_id']] = $act;
            }
        }
        if($saleActArr) {
            $tempActList = $this->getActList("sale_act_id in(".implode(',',$saleActArr).")",'sale_title,store_name,store_id,sale_act_id');
            if($tempActList) {
                foreach ($tempActList as $v) {
                    $hashData[$v['sale_act_id']][$v['sale_act_id']] = serialize($v);
                    $actList[$v['sale_act_id']] = $v;
                }
            }
        }
        if($hashData) {
            foreach ($hashData as $k=>$v) {
                \Redis\Db1\SaleOrderRedisModel::getInstance()->tableHMSet('orderGoods_'.$k,$v,\Our\ApiConst::oneDaySecond);
            }
        }
        return $actList;
    }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

}
