<?php
namespace Business\Common;
use OSS\Common;

/**
 * 广告位
 * User: liuyuzhen
 * Date: 2018/5/28
 * Time: 15:13
 * Description:
 */

class AdvServiceModel extends \Business\AbstractModel{

    public function getHomeAdv(){
        $topAdvs = $this->getHomeIndexAdvs();
        $popUpAdv = $this->getPopUpAdvs();
        $middleAdvs = $this ->getHomeMiddleAdvs();
        $returnAdvs = array();
        if($popUpAdv){
            $returnAdvs['popUpAdv'] = $popUpAdv;
        }
        if($topAdvs){
            $returnAdvs['topAdvs'] = $topAdvs;
        }
        if($middleAdvs){
            $returnAdvs['middleAdvs'] = $middleAdvs;
        }
        return $returnAdvs;
    }

    /**
     * 获取购物车为空时广告位
     * @throws \Our\Exception
     */
    public function getEmptyCartAdvs(){
        $advInstance = \DAO\Adv\AdvModel::getInstance();

        $advs = \Our\RedisHelper::cachedFunction(\Redis\Db9\AdvRedisModel::getInstance(),array(&$advInstance, 'getPostionAdv'),array(\Our\AdvConst::advEmptyCart),\Our\ApiConst::oneHour,array(\Our\AdvConst::advEmptyCart));
        return $advs;
    }


    /**
     * 获取平台分类页面顶部广告位内容
     */
    public function getHomeClassAdvs(){

        $advInstance = \DAO\Adv\AdvModel::getInstance();

        $advs = \Our\RedisHelper::cachedFunction(\Redis\Db9\AdvRedisModel::getInstance(),array(&$advInstance, 'getPostionAdv'),array(\Our\AdvConst::advPositionClassTop),\Our\ApiConst::oneHour,array(\Our\AdvConst::advPositionClassTop));
        return $advs;
    }

    public function getPopUpAdvs(){
        $advInstance = \DAO\Adv\AdvModel::getInstance();

        $advs = \Our\RedisHelper::cachedFunction(\Redis\Db9\AdvRedisModel::getInstance(),array(&$advInstance, 'getPostionAdv'),array(\Our\AdvConst::advPositionPopUp),\Our\ApiConst::oneHour,array(\Our\AdvConst::advPositionPopUp));
        $adv = $advs[0];
        return $adv;
    }

    /**
     * 获取首页顶部广告位
     */
    public function getHomeIndexAdvs(){

        $advInstance = \DAO\Adv\AdvModel::getInstance();

        $advs = \Our\RedisHelper::cachedFunction(\Redis\Db9\AdvRedisModel::getInstance(),array(&$advInstance, 'getPostionAdv'),array(\Our\AdvConst::advPositionHomeTop),\Our\ApiConst::oneHour,array(\Our\AdvConst::advPositionHomeTop));
        return $advs;
    }

    /**
     * 获取首页中部广告位
     */
    public function getHomeMiddleAdvs(){

        $advInstance = \DAO\Adv\AdvModel::getInstance();
        $advInstance->getPostionAdv(\Our\AdvConst::advPositionHomeMiddle);
        $advs = \Our\RedisHelper::cachedFunction(\Redis\Db9\AdvRedisModel::getInstance(),array(&$advInstance, 'getPostionAdv'),array(\Our\AdvConst::advPositionHomeMiddle),\Our\ApiConst::oneHour,array(\Our\AdvConst::advPositionHomeMiddle));
        return $advs;
    }


    public function getAdvs($where){
        $return = array();
        if($where['advType'] == \Our\ApiConst::advPositionHomeTopIndex){
            $advs = $this->getHomeIndexAdvs();
            if($advs){
                $return['content']      = $advs;
                $return['type']         = \Our\ApiConst::one;
                $return['intervalTime'] = \Our\AdvConst::advIntervalSecond;
            }

        }else if($where['advType'] == \Our\ApiConst::advPositionHomeMiddleIndex){
            $advs = $this->getHomeMiddleAdvs();
            if($advs){
                $return['content']      = $advs;
                $return['type']         = \Our\ApiConst::one;
                $return['intervalTime'] = \Our\AdvConst::advIntervalSecond;
            }
        }
        if($return){
            return $return;
        }
        return false;
    }

    public function getStoreCover($where){
        $this->checkAdvWhere($where);
        $advRedis = \Redis\Db9\AdvRedisModel::getInstance();
        $storeCoverKey = \Our\NameConst::storeCoverPrefix.$where['storeId'];
        $storeCover = $advRedis->find($storeCoverKey);
        if(!$storeCover){
            $advMobileDao = \DAO\Adv\AdvMobileModel::getInstance();
            $advMobileSql = "store_id = {0} and position = {1} and state ={2} and start_time < {3} and end_time >= {4} and is_use = {5}";
            $advMobileSql = \Our\Common::format($advMobileSql,$where['storeId'],\Our\ApiConst::storeAdvPositionTop,\Our\ApiConst::one,time(),time(),\Our\ApiConst::one);
            $advMobileField = 'href,src';
            $advMobileList = $advMobileDao->getList($advMobileSql,$advMobileField,array('adv_id'=>\Our\NameConst::desc));
            if($advMobileList){
                $storeCover = \Our\Common::getStaticFile($advMobileList[0]['src'],\Our\ImageConst::advSrcImagePath);
            }else{
                $storeAdvPositionDao = \DAO\Adv\StoreAdvPositionModel::getInstance();
                $storeAdvPosition = $storeAdvPositionDao->find(array('ap_id'=>\Our\ApiConst::storeAdvPositionTop));
                $storeCover = \Our\Common::getStaticFile($storeAdvPosition['default_content'],\Our\ImageConst::advSrcImagePath);
            }
            $advRedis->update($storeCoverKey,$storeCover,\Our\ApiConst::oneDaySecond);
        }
        return array('storeCover'=>$storeCover);

    }

    public function getStoreMiddleAdvs($where){
        $this->checkAdvWhere($where);
        $advRedis = \Redis\Db9\AdvRedisModel::getInstance();
        $storeMiddleAdvsKey = \Our\NameConst::storeMiddleAdvsPrefix.$where['storeId'];
        $storeMiddleAdvs = $advRedis->find($storeMiddleAdvsKey);
        if(!$storeMiddleAdvs){
            $storeMiddleAdvs = $this->getStoreAdvs($where,\Our\ApiConst::storeAdvPositionMiddle);
            $advRedis->update($storeMiddleAdvsKey,$storeMiddleAdvs,\Our\ApiConst::oneDaySecond);
        }
        return $storeMiddleAdvs;

    }

    public function getStoreAdvs($where,$position){

        $advMobileDao = \DAO\Adv\AdvMobileModel::getInstance();
        $advMobileSql = "store_id = {0} and position = {1} and state ={2} and start_time < {3} and end_time >= {4} and is_use = {5}";
        $advMobileSql = \Our\Common::format($advMobileSql,$where['storeId'],$position,\Our\ApiConst::one,time(),time(),\Our\ApiConst::one);
        $advMobileField = 'href,src';
        $advMobileList = $advMobileDao->getList($advMobileSql,$advMobileField,array('adv_id'=>\Our\NameConst::desc));
        if($advMobileList){
            $advs = array();
            foreach($advMobileList as $adv){
                $temp = array();
                $temp['imageUrl'] = \Our\Common::getStaticFile($adv['src'],\Our\ImageConst::advSrcImagePath);
                $temp['href'] = $adv['href'];
                $advs[] = $temp;
            }
        }else{
            $storeAdvPositionDao = \DAO\Adv\StoreAdvPositionModel::getInstance();
            $storeAdvPosition = $storeAdvPositionDao->find(array('ap_id'=>\Our\ApiConst::storeAdvPositionTop));
            $imageUrl = \Our\Common::getStaticFile($storeAdvPosition['default_content'],\Our\ImageConst::advSrcImagePath);
            $advs[] = array('href'=>'','imageUrl'=>$imageUrl);
        }
        return $advs;
    }


    public function checkAdvWhere($where){
        if(!$where['storeId']){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyAdvStore);
        }
        return true;
    }

    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}