<?php

namespace Business\User;


class FeedBackServiceModel extends \Business\AbstractModel
{


    public function init() {

    }

    /**
     * 店铺意见反馈
     * @param $param
     * @param $storeId
     * @param $memberId
     * @return bool
     * @throws \Exception
     */
    public function saveFeedback($param, $storeId, $memberId) {
        $storeDAO = \DAO\StoreModel::getInstance();
        $feedbackDescribe = trim($param['feedbackDescribe']);
        $feedbackTelephone = $storeDAO->getInfoById($storeId, 'store_phone', true);
        if(!$feedbackDescribe){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyFeedbackDescribe);
        }
        $insert = array();
        $insert['feedback_type'] = 1;   //店铺意见反馈
        $insert['feedback_describe'] = $feedbackDescribe;
        $insert['feedback_time'] = TIMESTAMP;
        $insert['feedback_telephone'] = $feedbackTelephone;
        $insert['member_id'] = $memberId;

        $return = \DAO\FeedBackModel::getInstance()->insert($insert);
        if(!$return){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::saveFeedbackError);
        }
        return true;

    }
    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

}
