<?php
namespace Redis\Db0;
/**
 * User: liuyuzhen
 * Date: 2018/6/4
 * Time: 18:13
 * Description:
 */
class MemberMappingRedisModel extends \Redis\Db0\AbstractModel {

    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_member_mapping';




    public function find($id) {
        $result = $this->get($this->calcKey($id));


        if($this->is_serialized($result)){
            return unserialize($result);
        }
        return $result;
    }
    public function tableCacheGet($id){
        $result = $this->get($this->calcKey($id));
        return $result;
    }
    public function tableCacheSet($id,$data,$experio){
        $res=$this->set($this->calcKey($id), $data,$experio);
        return $res;
    }
    public function calcKey($id) {
        return $this->_tableName . self::DELIMITER . $id;
    }

    public function update($id, $data,$expire=0) {
        return $this->set($this->calcKey($id), serialize($data),$expire);
    }

    public function tableHSet($h,$key,$val,$experio=0){
        return $this->hset($this->calcKey($h),$key,$val,$experio);
    }

    public function tableHGet($h,$key){
        return $this->hget($this->calcKey($h),$key);
    }

    public function tableHMSet($h,$keysvalue,$experio=0){
        return $this->hmset($this->calcKey($h),$keysvalue,$experio);
    }

    public function tableHMGet($h,$keyvalues){
        return $this->hmget($this->calcKey($h),$keyvalues);
    }

    public function tableKeys($prekey){
        return $this->keys($this->calcKey($prekey));
    }
    public function tableHKeys($prekey){
        return $this->hkeys($this->calcKey($prekey));
    }
    public function tableDelAll($data){
        return $this->delAll($data);
    }

    public function tableHGAll($h){
        return $this->hGetAll($this->calcKey($h));
    }

    public function tableDel($h){
        return $this->del($this->calcKey($h));
    }

    public function tableSAddArray($h,array $value){
        return $this->sAddArray($this->calcKey($h),$value);
    }

    public function tableSIsMember($h,$value){
        return $this->sIsMember($this->calcKey($h),$value);
    }

    public function tableKeyExists($h){
        return $this->exists($this->calcKey($h));
    }

    /**
     * 类实例
     *
     * @var \Redis\Db0\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \Redis\Db0\UserModel
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

}