<?php

namespace DAO;



class StoreGoodsClassModel extends \DAO\AbstractModel {



    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_store_goods_class';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'stc_id';
    public function init(){

    }
    public function getList($where,$field,$order = true){
        $this->setDb($this->dbName);
        if($order){
            return $this->db->select($field)->from($this->_tableName)->where($where)->order('stc_sort','DESC')->fetchAll();
        }
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchAll();
    }
//    public function _getList($where,$field){
//        $this->setDb();
//        $data = $this->db->select($field)->from($this->_tableName)->join('han_store_goods_class_goods','han_store_goods_class.stc_id = han_store_goods_class_goods.stc_id','inner')->join('han_goods_common','han_goods_common.goods_commonid = han_store_goods_class_goods.goods_common_id')->where($where)->where('goods_verify = 1')->where('goods_state = 1')->order('stc_sort','DESC')->order('gc_sort','DESC')->fetchAll();
//        return $this->option($data);
//    }
//    public function getListWithSale($where,$field,$actIds){
//        $this->setDb();
//        $str = "select ".$field." FROM ".$this->_tableName." INNER JOIN `han_store_goods_class_goods` ON(han_store_goods_class.stc_id = han_store_goods_class_goods.stc_id)   JOIN `han_goods_common` ON(han_goods_common.goods_commonid = han_store_goods_class_goods.goods_common_id) LEFT JOIN (SELECT MIN(discount_price) discount_price,goods_commonid,goods_id FROM han_sale_goods where sale_act_id in(".implode(',',$actIds).") GROUP BY goods_commonid) a on (han_goods_common.goods_commonid = a.goods_commonid) ";
//        $str .= 'where(goods_verify = 1) AND (goods_state = 1) AND (';
//        $str .= $where.')';
//        $str .= ' ORDER BY stc_sort DESC,gc_sort DESC';
//        $data = $this->db->query($str);
//        $data = $data->rows;
//        return $this->option($data);
//    }

    /**
     * 整理数据
     * @param $data
     * @return array
     */
    public function option($data){
        $recommendGoods = array();
        if($data){
            foreach ($data as $v){
                $goods = array('goodsCommonId'=>$v['goods_commonid'],'goodsName'=>$v['goods_name'],'goodsImage'=>\Our\ImageUtil::getGoodsImgUrl($v['goods_image']),'goodsPrice'=>(int)$v['price'],'goodsMarketPrice'=>$v['goods_marketprice']);
                if(key_exists($v['stc_id'],$recommendGoods)){
                    if(count($recommendGoods[$v['stc_id']]['goods']) >= 8){
                        continue;
                    }
                    array_push($recommendGoods[$v['stc_id']]['goods'],$goods);
                }else{
                    $recommendGoods[$v['stc_id']] = array('stcId'=>$v['stc_id'],'stcName'=>$v['stc_name'],'goods'=>array($goods));
                }

            }
        }
        return array_values($recommendGoods);
    }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance($dbName=\Our\DbNameConst::salveDBConnectName) {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

}
