<?php

namespace DAO;


class SaleGoodsModel extends \DAO\AbstractModel {



    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_sale_goods';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'sale_goods_id';
    public function init(){

    }

    public function getOne($where,$field){
        $this->setDb();
        return $this->db->from($this->_tableName)->select($field)->where($where)->fetchOne();
    }
    public function getList($where,$field,$limit = []){
        $this->setDb();
        if($limit){
            return $this->db->from($this->_tableName)->select($field)->where($where)->limit($limit[0],$limit[1])->fetchAll();
        }
        return $this->db->from($this->_tableName)->select($field)->where($where)->fetchAll();
    }
    public function getActAndGoods($where,$field){
        $this->setDb();
        return $this->db->from($this->_tableName)->select($field)->join('han_sale_activity','han_sale_activity.sale_act_id = han_sale_goods.sale_act_id','inner')->where($where)->where('sale_act_state = 1')->where('sale_start_date <='.time())->where('sale_end_date >='.time())->fetchAll();
    }

    /**
     * 返回销售商品信息 没有返回空
     * @param $storeId
     * @param $goodsId
     * @return string
     */
    public function getSaleGoods($storeId,$goodsId,$common = false){
        $data = [];
        $saleDb4Redis = \Redis\Db4\SaleGoodsRedisModel::getInstance();
        if($saleDb4Redis->tableKeyExists('storeId:'.$storeId) === false || $saleDb4Redis->tableKeyExists('storeId_cid:'.$storeId) === false){
            //$saleGoods = \DAO\SaleGoodsModel::getInstance()->getList(array('storeid'=>$storeId),'*');
            $saleGoods = $this->getActAndGoods(array('storeid'=>$storeId),'han_sale_activity.sale_start_date,han_sale_activity.sale_end_date,han_sale_goods.*');
            if($saleGoods) {
                $goods = [];
                $goodsCommon = [];
                foreach ($saleGoods as $v){
                    if(key_exists($v['goods_commonid'],$goodsCommon)){
                        if($v['discount_price'] >= unserialize($goodsCommon[$v['goods_commonid']])['discount_price']){
                            continue;
                        }
                    }
                    $serialize = serialize($v);

                    $goods[$v['goods_id']] = $serialize;
                    $goodsCommon[$v['goods_commonid']] = $serialize;

                    if($common){
                        if($v['goods_commonid'] == $goodsId){
                            $data = $v;
                        }
                    }else{
                        if($v['goods_id'] == $goodsId){
                            $data = $v;
                        }
                    }
                }
            }else{
                $goods = array('empty'=>1);
                $goodsCommon = array('empty'=>1);
            }
            $saleDb4Redis->tableHMSet('storeId:'.$storeId,$goods,\Our\ApiConst::oneDaySecond);
            $saleDb4Redis->tableHMSet('storeId_cid:'.$storeId,$goodsCommon,\Our\ApiConst::oneDaySecond);
        }else{
            if($common){
                $data = $saleDb4Redis->tableHGet('storeId_cid:'.$storeId,$goodsId);
            }else{
                $data = $saleDb4Redis->tableHGet('storeId:'.$storeId,$goodsId);
            }
            if($data){
                $data = unserialize($data);
                if(!($data['sale_start_date'] <= time() && $data['sale_end_date'] >= time())){
                    return false;
                }
            }
        }
        return $data;
    }

    /**
     * 判断是否有参加这个商品的销售活动 有的话返回销售价格
     * @param $data  销售商品信息
     * @param array $activities 用户参加的活动id数组
     * @return string
     */
    public function getSalePrice($data,array $activities,$array = false){
        $activitiesKeys = array_keys($activities);
        $price = '';
        if($data && in_array($data['sale_act_id'],$activitiesKeys)){
            $price = $data['discount_price'];
        }
        if($array) {
            return array('sale_act_id'=>$data['sale_act_id'],'sale_id'=>$activities[$data['sale_act_id']],'price'=>$price);
        }
        return $price;
    }

    public function addOrderGoodsList($orderGoodsId){
        $orderGoodsRedis = \Redis\Db5\OrderGoodsRedisModel::getInstance();
        $orderGoodsRedis->tableLPush('saleGoods',$orderGoodsId);
    }
    public function popOrderGoodsList(){
        $orderGoodsRedis = \Redis\Db5\OrderGoodsRedisModel::getInstance();
        return $orderGoodsRedis->tableLPop('saleGoods');
    }

    public function getListByActArr($saleActArr) {
        $saleGoods = $this->getList('sale_act_id in('.implode(',',$saleActArr).')','sale_act_id,goods_id');
        $saleGoods = [];
        foreach ($saleActArr as $k=>$v) {
            $goodsIds = \Redis\Db1\SaleOrderRedisModel::getInstance()->tableHGet('orderGoods_'.$v,$v.'_'.'goodsIds');
            if($goodsIds){
                unset($saleActArr[$k]);
                $goodsIds =  unserialize($goodsIds);
                $saleGoods = array_merge($saleGoods,$goodsIds);
            }
        }
        if($saleActArr) {
            $tempSaleGoods = \DAO\SaleGoodsModel::getInstance()->getList('sale_act_id in('.implode(',',$saleActArr).')','sale_act_id,goods_id');
            if($tempSaleGoods) {
                $temp = [];
                foreach ($tempSaleGoods as $v) {
                    $temp[$v['sale_act_id']][] = $v;
                }
                foreach ($temp as $k=>$v) {
                    $saleGoods = array_merge($saleGoods,$v);
                    $hashData[$k.'_goodsIds'] = serialize($v);
                    \Redis\Db1\SaleOrderRedisModel::getInstance()->tableHMSet('orderGoods_'.$k,$hashData,\Our\ApiConst::oneDaySecond);
                }
            }
        }
        return $saleGoods;
    }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

}
