<?php
use \Our\ApiConst;
use \Our\Log;
/**
 * 当有未捕获的异常, 则控制流会流到这里
 */
class ErrorController extends \Our\Controller_Abstract {
    const notFound=404;
    const numberLimit=10000;
    public function init() {
        \Yaf\Dispatcher::getInstance()->disableView();
    }
    public  function returnMessage($returnMessage)
    {
        $data['status']='fail';
        $data['resultCode']=$returnMessage['resultCode'];
        $data['longMessage']=$returnMessage['longMessage'];
        $data['shortMessage']=$returnMessage['shortMessage'];
        $data['encryptType'] = ApiConst::plainEncode;
        $data['requestId'] = parent::createRequsetId();
        $data['requestTime']=TIMESTAMP;
        $data['responseTime'] = time();
        $data['responseContent']=array();
        $data['Data'] = $_POST;
        $log = Log::getInstance();
       // $log->write(print_r($data, true));
        $log->write(json_encode($data));
        // unset($data['requestData']);
        header("Access-Control-Allow-Origin: *");
        header('Access-Control-Allow-Method: *');
        header('Access-Control-Allow-Headers: x-requested-with,content-type');
        header('Content-type: application/json');
        echo json_encode($data);
        exit;
    }
    public function errorAction($exception) {
        if ($exception->getCode() > self::numberLimit) {
            //这里可以捕获到应用内抛出的异常
            $res['resultCode']= $exception->getCode();
            $res['shortMessage']= $exception->getMessage();
            $res['longMessage']= $exception->getMessage();
            self::returnMessage($res);
        }
        switch ($exception->getCode()) {

            case 404://404
            case 515:
            case 516:
            case 517:
                //输出404
                header(\Our\Common::getHttpStatusCode(404));
                echo self::notFound;
                exit();
                break;
            default :$this->systemError($exception);
                break;
        }
        throw $exception;
    }
    public function systemError($exception){
        $res['resultCode']= $exception->getCode();
        $res['shortMessage']= $exception->getMessage();
        $res['longMessage']= $exception->getMessage();
        self::returnMessage($res);
    }

}
