<?php
namespace Payment;
/**
 * User: liuyuzhen
 * Date: 2018/7/5
 * Time: 11:39
 * Description:
 */
class WxLitePay extends \Payment\TencentPay{

    private $refundUrl="https://api.mch.weixin.qq.com/secapi/pay/refund";
    public function __construct()
    {
        $this->appid = \Our\PayConst::wxLiteAppId;
        $this->notify_url = \Our\Common::getBaseUrl().\Our\PayConst::wxLiteNotifyUrl;
        $this->s_notify_url = \Our\Common::getBaseUrl().\Our\PayConst::wxLiteNotifyUrl;
        //$this->notify_url = \Our\NameConst::httpPrefix. $_SERVER['SERVER_NAME'] .\Our\PayConst::wxLiteNotifyUrl;
        $this->mch_id = \Our\PayConst::wxPayMchId;
        $this->key = \Our\PayConst::wxSPayKey;
        $this->sslcert_path = \Our\PayConst::wxSslcertPath;
        $this->sslkey_path = \Our\PayConst::wxSslkeyPath;
        $this->pay_url = \Our\PayConst::wxPayUrl;
        $this->tradeType = \Our\PayConst::wxLiteTradeType;
        $this->s_mch_id =  \Our\PayConst::wxSPayMchId;
        $this->s_key =  \Our\PayConst::wxSPayKey;
        $this->s_appid = \Our\PayConst::wxSPayAppId;
	}


    public function doPay($orderInfo){
        if(isset($orderInfo['subMchId'])){
            $this->setServiceRequestParams($orderInfo);
        }else{
            $this->setRequestParams($orderInfo);
        }
        //$this->setRequestParams($orderInfo);
        $wxAppParameters = $this->getParameters();
        $prepayId = $wxAppParameters['prepay_id'];
        unset($wxAppParameters['prepay_id']);
        $returnData = array(
            'credential'=>array(\Our\NameConst::wxLiteChannel=>$wxAppParameters),
            'app_id'=>$this->appid,
            'prepay_id'=>$prepayId
        );
        return $returnData;
    }

    public function getParameters(){
        $wxApiObj["appId"] = $this->appid;
        $timeStamp = TIMESTAMP;
        $wxApiObj["timeStamp"] = "$timeStamp";
        $wxApiObj["nonceStr"] = \Our\CommonExtension::createNoncestr();
        $wxApiObj['package'] = 'prepay_id='.$this->prepay_id;
        $wxApiObj['signType'] = 'MD5';
        $wxApiObj["paySign"] = $this->getSign($wxApiObj);
        $wxApiObj["prepay_id"] = $this->prepay_id;

        return $wxApiObj;
    }


    public function refund($param){
        if($param['subMchId']){
            $this->refundService($param);
        }else{
            $this->refundCommon($param);
        }

    }

    public function refundService($param){
        $this->key = $this->s_key;
        $this->sslcert_path =  \Our\PayConst::wxServiceSslcertPath;
        $this->sslkey_path = \Our\PayConst::wxServiceSslkeyPath;
        $total_fee = intval($param['totalFee']);
        $refund_fee = intval($param['refundFee']);
        if(APP_ENV == 'develop'||APP_ENV == 'test'||APP_ENV == 'pre' || APP_ENV=='ccwdevelop'|| APP_ENV=='lyztest'){
            $this->parameters['total_fee'] = 1;
            $this->parameters['refund_fee'] = 1;
        } else {
            $this->parameters['total_fee'] = $total_fee;
            $this->parameters['refund_fee'] = $refund_fee;
        }
        $this->parameters['appid']=$this->s_appid;
        $this->parameters['mch_id']=$this->s_mch_id;
        $this->parameters['sub_appid']=$this->appid;

        $this->parameters['sub_mch_id'] = $param['subMchId'];
        $this->parameters['nonce_str'] = $this->createNoncestr(32);
        //$this->parameters['transaction_id'] = $param['transactionId'];

        $this->parameters['out_trade_no'] = $param['outTradeNo'];
        $this->parameters['out_refund_no'] = $param['refundOrderNo'];

        $xml = $this->createXml();
        $response = $this->postXmlSSLCurl($xml, $this->refundUrl, 6);
        $values = $this->xmlToArray($response);
        if ($values['return_code'] != 'SUCCESS') {
            return $values;
        }
        $this->checkSign($values);
        return $values;
    }

    public function refundCommon($param){
        $total_fee = intval($param['totalFee']);
        $refund_fee = intval($param['refundFee']);
        if(APP_ENV == 'develop'||APP_ENV == 'test'||APP_ENV == 'pre' || APP_ENV=='ccwdevelop'){
            $this->parameters['total_fee'] = 1;
            $this->parameters['refund_fee'] = 1;
        } else {
            $this->parameters['total_fee'] = $total_fee;
            $this->parameters['refund_fee'] = $refund_fee;
        }
        $this->parameters['out_refund_no'] = $param['refundOrderNo'];
        $this->parameters['out_trade_no'] = $param['outTradeNo'];
        $this->parameters['op_user_id'] = $this->mch_id;
        $this->parameters['nonce_str'] = $this->createNoncestr(32);
        $this->parameters['appid'] = \Our\PayConst::wxLiteAppId;
        $this->parameters['mch_id'] = \Our\PayConst::wxPayMchId;
        $xml = $this->createXml();
        $response = $this->postXmlSSLCurl($xml, $this->refundUrl, 6);
        $values = $this->xmlToArray($response);
        if ($values['return_code'] != 'SUCCESS') {
            return $values;
        }
        $this->checkSign($values);
        return $values;
    }


    /**
     * 类实例
     *
     */
    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

}
