<?php

class CommentController extends \Our\Controller_AbstractApi {

    private $commentService;
    public function init(){
        parent::init();
        $this->commentService = \Business\Goods\CommentServiceModel::getInstance();
    }

    public function getCommentsAction(){
        $pageIndex = $this->getPageIndex();
        $pageSize = $this->getPageSize(\Our\PageConst::pBlPage);
        $this->req[\Our\NameConst::data]['pageIndex'] = $pageIndex;
        $this->req[\Our\NameConst::data]['pageSize'] = $pageSize;
        $info = $this->commentService->getComments($this->req[\Our\NameConst::data],$this->memberId);
        $this->success($info);

    }
    public function getCommentAction(){

        $info = $this->commentService->getComment($this->req[\Our\NameConst::data],$this->memberId);
        if($info){
            $this->success($info);
        }
        \Error\ErrorModel::throwException(\Error\CodeConfigModel::storeEvaNotExist);
    }
    /**
     * 获取商品列表
     */
    public function getGoodsAction(){
        $goods = $this->commentService->getGoods($this->req[\Our\NameConst::data],$this->memberId);
        $this->success($goods);
    }
    public function testAction(){
        $info = $this->commentService->addBrowseRecord($this->req[\Our\NameConst::data],$this->memberId);
    }

}