<?php

namespace DAO;


/**
 */
class EvaluateStoreModel extends \DAO\AbstractModel {



    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_evaluate_store';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'seval_id';
    public function init(){

    }

    private function _findByStoreId($store_id){
        $this->setDb();
        $result = array();
        $field = 'AVG(seval_desccredit) as store_desccredit,';
        $field .= 'AVG(seval_servicecredit) as store_servicecredit,';
        $field .= 'AVG(seval_deliverycredit) as store_deliverycredit,';
        $field .= 'COUNT(seval_id) as count';
        $where = array('seval_storeid'=>$store_id);
        $grade=$this->db->select($field)->from($this->_tableName)->where($where)->fetchOne();
        $result['store_desccredit']['text'] = '描述相符';
        $result['store_servicecredit']['text'] = '服务态度';
        $result['store_deliverycredit']['text'] = '发货速度';
        if(intval($grade['count']) > 0) {
            $result['store_desccredit']['credit'] = round($grade['store_desccredit'], 1);
            $result['store_servicecredit']['credit'] = round($grade['store_servicecredit'], 1);
            $result['store_deliverycredit']['credit'] = round($grade['store_deliverycredit'], 1);
        } else {
            $result['store_desccredit']['credit'] = round(5, 1);
            $result['store_servicecredit']['credit'] = round(5, 1);
            $result['store_deliverycredit']['credit'] = round(5, 1);
        }
        return $result;
    }

    public function getGrade($store_id){
        $info['store_credit'] = $this->_findByStoreId($store_id);
        $info['store_credit_average'] = round((($info['store_credit']['store_desccredit']['credit'] + $info['store_credit']['store_servicecredit']['credit'] + $info['store_credit']['store_deliverycredit']['credit']) / 3), 1);
        $info['store_credit_percent'] = intval($info['store_credit_average'] / 5 * 100);
        return $info;
    }
    public function insert($data){
        $this->setDb("resources.database.params");
        return $this->db->insert($this->_tableName)->rows($data)->execute();
    }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }


}
