<?php

namespace DAO;



class SettingModel extends \DAO\AbstractModel {



    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_setting';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = '';
    public function init(){

    }
   public function getList($where = 1,$field = '*'){
        $this->setDb($this->dbName);
        return $this->db->from($this->_tableName)->select($field)->where($where)->fetchAll();
   }
   public function getListCache($field=array()){
       $settingDb0Redis=\Redis\Db1\SettingRedisModel::getInstance();
       if($settingDb0Redis->tableKeyExists('setting') === false){
           $settings = $this->getList();
           if($settings){
               $settingArray = [];
               foreach ($settings as $v){
                   $settingArray[$v['name']] = $v['value'];
               }
           }
           $settingDb0Redis->tableHMSet('setting',$settingArray,\Our\ApiConst::tenDaySecond);
           if($field){
               $settings = [];
               foreach ($field as $v){
                   $settings[$v] = $settingArray[$v];
               }
               return $settings;
           }
       }else{
           if($field){
               return $settingDb0Redis->tableHMGet('setting',$field);
           }
           $settingArray = $settingDb0Redis->tableHGAll('setting');
       }
       return $settingArray;
   }

    /**
     * 获取分享信息
     * @return mixed
     */
    public function getShareInfo(){
        $settings = $this->getListCache(array('common_share_title','site_name','common_share_desc','common_share_url','common_share_img'));
        $share['title']=$settings['common_share_title']?$settings['common_share_title']:$settings['site_name'];
        $share['desc']=$settings['common_share_desc']?$settings['common_share_desc']:$settings['site_name'];
        $url = $settings['common_share_url'];
        $share['link']=$url?$url:'http://www.shenbd.com';
        $img_url = $this->getShareSrc($settings['common_share_img']);
        $share['imgUrl'] = $img_url;
        return $share;
    }
    /**
     * 分享图片
     *
     * @param $storeLabel
     * @return string
     */
    public function getShareSrc($img)
    {
        return \Our\Common::getStaticFile($img, \Our\ImageConst::defaultPath, 'ossHost');

    }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance($dbName=\Our\DbNameConst::salveDBConnectName) {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

}
