<?php

class OrderController extends \Our\Controller_AbstractApi {


    /**
     * 获取订单列表
     *
     * @ccw
     */

    public function getOrdersAction(){
        $orderService=\Business\Order\OrderServiceModel::getInstance();
        $pageIndex=$this->getPageIndex();
        $pageSize=$this->getPageSize();
        if(isset($this->req[\Our\NameConst::data]['orderState'])&& !empty($this->req[\Our\NameConst::data]['orderState'])){
            $orderState=$this->req[\Our\NameConst::data]['orderState'];
        }else{
            $orderState=false;
        }
        $keyword=$this->req[\Our\NameConst::data]['keyword']?$this->req[\Our\NameConst::data]['keyword']:FAlSE;
        $orders=$orderService->getList($this->memberId,$keyword,$pageIndex,$pageSize,$orderState);
        if(!empty($returnData)){
            throw new \Exception(json_encode($returnData));
        }
        $this->success($orders);

    }
    /**
     * 取消订单
     *
     * @ccw
     */

    public function cancelAction(){
        $orderService=\Business\Order\OrderServiceModel::getInstance();
        $orderService->cancel($this->req[\Our\NameConst::data]['orderId'],$this->memberId);
        $this->success(new \stdClass(),\Our\DescribeConst::cancelOrderSuccess);
    }

    /**
     * 确认收货
     *
     * @ccw
     */

    public function receiveAction(){
        $orderService=\Business\Order\OrderServiceModel::getInstance();
        $orderService->confirmRecieve($this->req[\Our\NameConst::data]['orderId'],$this->memberId);
        $this->success(new \stdClass(),\Our\DescribeConst::confirmOrderSuccess);
    }
    /**
     * 获得物流信息
     *
     * @ccw
     */

    public function getExpressAction(){
        $orderService=\Business\Order\OrderServiceModel::getInstance();
       // $expreddInfo= $orderService->getExpressInfo($this->req[\Our\NameConst::data]['orderId']);
        $expreddInfo=\Our\RedisHelper::cachedFunction(\Redis\Db5\OrderRedisModel::getInstance(),array(&$orderService, 'getExpressInfo'),array($this->req[\Our\NameConst::data]['orderId']),\Our\ApiConst::oneHour,array($this->req[\Our\NameConst::data]['orderId']));;

        $this->success($expreddInfo,\Our\DescribeConst::getExpreeSuccess);
    }

    /**
     * 获得订单详情
     *
     * @ccw
     */

    public function detailAction(){
        $orderService=\Business\Order\OrderServiceModel::getInstance();
        $detail=$orderService->getOrderDetail($this->req[\Our\NameConst::data]['orderId']);
        $this->success($detail);

    }

    /**
     * 获得退款详情
     *
     * @ccw
     */
    public function refundOrderAction(){
        $refundService =\Business\Order\RefundServiceModel::getInstance();
        $refund=$refundService->getRefundOrder($this->memberId,$this->req[\Our\NameConst::data]['orderId'],$this->req[\Our\NameConst::data]['goodsId']);
        $this->success($refund);
    }

    /**
     * 申请退货退款接口
     *
     * @ccw
     */
    public function addRefundAction(){
        $refundService =\Business\Order\RefundServiceModel::getInstance();
        $res=$refundService->addRefund($this->memberId,$this->req[\Our\NameConst::data]);
        $this->success(array('refundId'=>$res),\Our\DescribeConst::applySuccess);

    }
    /**
     * 获得退款详情接口
     *
     * @ccw
     */
    public function getRefundDetailAction(){
        $refundService =\Business\Order\RefundServiceModel::getInstance();
        $res=$refundService->getInfo($this->req[\Our\NameConst::data]['refundId']);
        $this->success($res);
    }
    /**
     * 申请平台介入
     *
     * @ccw
     */
    public function applyPlatformAction(){
        $refundService =\Business\Order\RefundServiceModel::getInstance();
        if(empty($this->req[\Our\NameConst::data]['refundId'])){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::paramsError);
        }
        $res=$refundService->platformIn($this->memberId,$this->req[\Our\NameConst::data]['refundId']);
        if($res){
            $this->success(array(),\Our\DescribeConst::applySuccess);
        }else{
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::applyError);
        }

    }

    /**
     * 获得所有物流公司
     *
     * @ccw
     */
    public function getAllExpressAction(){
        $orderService=\Business\Order\RefundServiceModel::getInstance();
        $expresses=$orderService->getAllExpress();
        $this->success(array('expresses'=>$expresses));
    }

    public function sendRefundShippingAction(){
        $refundService=\Business\Order\RefundServiceModel::getInstance();
        $refundService->addRefundShipping($this->memberId,$this->req[\Our\NameConst::data]);
        $this->success(new \stdClass(),'物流信息添加成功');
    }
    /**delete
     * 获得退款列表
     *
     * @ccw
     */
    public function getRefundsAction(){
        $refundService=\Business\Order\RefundServiceModel::getInstance();
        $pageIndex=$this->getPageIndex();
        $pageSize=$this->getPageSize();
        $res=$refundService->getList($this->memberId,$pageIndex,$pageSize);
        $this->success($res);
    }
    /**d
     * 删除订单接口
     *
     * @ccw
     */
    public function deleteAction(){
        $orderService=\Business\Order\OrderServiceModel::getInstance();
        $orderService->delete($this->memberId,$this->req[\Our\NameConst::data]['orderId']);
        $this->success(new \stdClass(),\Our\DescribeConst::deleteOrderSuccess);
    }


    /**
     * 获取订单支付结果
     */
    public function getOrderPayResultAction(){
        $orderService=\Business\Order\OrderServiceModel::getInstance();
        $return = $orderService->getOrderPayResult($this->req[\Our\NameConst::data],$this->memberId);
        $this->success($return);
    }

    public function goToPayAction(){
        $orderService=\Business\Order\OrderServiceModel::getInstance();
        $paySn = $orderService->goToPay($this->memberId,$this->req[\Our\NameConst::data]['orderId']);
        $this->success(array('paySn'=>$paySn));
    }

}
