<?php

/**
 * 推送10秒推送一次
 * 推送10秒推送一次
 *
 * @author chenjiebin <sjlinyu@qq.com>
 */

define("APPLICATION_PATH", realpath(dirname(__FILE__) . '/../../../')); //指向public的上一级
require APPLICATION_PATH . '/scripts/crontab/baseCli.php';
require APPLICATION_PATH . '/scripts/crontab/common.php';
error_reporting(E_ALL ^ E_NOTICE);
class cliOrderClose extends basecli
{
    const CLI_ADMIN_ID = 255;
    private $bDoUnLock  = FALSE;   // 是否允许释放 LOCK 文件
    private $_debug = 0;
    private $lockFileName;
    private $fromState;
    private function mkdirs($dir, $mode = 0777)
    {
        if (is_dir($dir) || @mkdir($dir, $mode)){
            return TRUE;
        }
        if (!$this->mkdirs(dirname($dir), $mode)){
            return FALSE;
        }
        return @mkdir($dir, $mode);
    }
    /**
     * 析构
     */
    public function __destruct()
    {
        parent::__destruct();
        if ($this->bDoUnLock)
        {
            @unlink($this->lockFileName);

        }
    }
    protected function autoPushMessage(){
        $conf = \Yaf\Registry::get('config')->get('redis.database.params');
        $redis = new \Redis();
        $redis->pconnect($conf['host'], $conf['port']);
        if (!empty($conf['password'])) {
            $redis->auth($conf['password']);
        }
        $clientPush=\JPush\ClientPush::getInstance();
       $memberCenterServiceDao=\Business\User\MemberCenterServiceModel::getInstance();
        //$messageService=\DAO\MessageHistoryModel::getInstance();
        while($pushData=$redis->rPop('push_center')){
            $addData = unserialize($pushData);
            $addData['message'] = unserialize($addData['message']);
            $res=$memberCenterServiceDao->getMessageSet($addData['toId']);
            if($res['canPush']!=\Our\ApiConst::one){
                continue;
            }
//            else{
//                if(!empty($res['timeDiff'])){
//                    $timeArr=explode('-',$res['timeDiff']);
//                    if(!empty($timeArr)){
//                        if(\Our\Common::isCurentTimeInSection($timeArr[0],$timeArr[1])){
//                            continue;
//                        }
//                    }
//                }
//
//            }
            $clientPush->push($addData);
        }
        $redis->close();
    }
    protected function autoPushClient(){
        $push=\Our\Push::getInstance();
        while($pushData=\Our\RedisHelper::lpop('client_push')){
            if($pushData['type']==\Our\ApiConst::messageReceiveOrderType){
                $push->recievedOrder($pushData['storeId'],$pushData['orderId']);
                continue;
            }
            $push->addOneToClient($pushData);
        }
        $goodsCommonService=\Business\Goods\GoodsCommonServiceModel::getInstance();
        $storesBase=$goodsCommonService->getAlertGoods();
        if($storesBase){
            $storesIds=array_column($storesBase,'storeId');
            $stores=$goodsCommonService->getGoodsCount($storesIds);
            if(!empty($stores)){
                foreach($stores as $store){
                    $push=\Our\Push::getInstance();
                    $pushData=array('storeId'=>$store['storeId'],
                        'type'=>\Our\ApiConst::messageGoodsAlert,
                        'waitReceiveCount'=>\Our\ApiConst::zero,
                        'waitDeliveryCount'=>0,
                        'waitGetCount'=>0,
                        'orderCount'=>\Our\ApiConst::zero,
                        'waitRefundProccessCount'=>\Our\ApiConst::zero,
                        'waitRefundReceiveCount'=>\Our\ApiConst::zero,
                        'refundCount'=>\Our\ApiConst::zero,
                        'alertCount'=>$store['count'],
                        'params'=>array('c'=>'shopkeeper',
                            'm'=>'orderDetail',
                            'orderId'=>$store['orderId']));
                    $push->addOneToClient($pushData);
                }

            }
        }

        $push->sendTcpMessage();
    }
    protected function _runCli()
    {

        $this->_debug = isset($this->aArgv[1]) ? intval($this->aArgv[1]) : 0;
        if ($this->_debug)
        {
            echo "*** Debug mode ***\n";
        }
        // Step: 02 检查是否已有相同CLI在运行中
        $lockDir=$this->_getBaseFileName('push');
        if(!$this->mkdirs($lockDir)){
            echo '****create dir fail  ****';
            exit;
        }
        $this->lockFileName = $lockDir .DS.'jpush.locks';
        if( file_exists( $this->lockFileName ) )
        {
            $stat = stat($this->lockFileName);
            if( (TIMESTAMP - $stat['mtime']) > 1800 )
            {
                echo "文件被锁超过1800秒，被强制删除";
                @unlink($this->lockFileName);
            }
            else
            {
                $this->halt( '[' . date('Y-m-d H:i:s') .'] The CLI is running'."\n");
            }
        }
        $this->bDoUnLock = true;
        if(APP_ENV =='pre' || APP_ENV=='product'){
            file_put_contents($this->lockFileName ,"running" ); // CLI 独占锁
        }
        $this->autoPushMessage();
        echo date('Y-m-d H:i:s',TIMESTAMP).'消息推送成功'."\r\n";
        $this->autoPushClient();
        echo date('Y-m-d H:i:s',TIMESTAMP).'客户端消息推送成功'."\r\n";



    }
}

$oCli = new cliOrderClose(TRUE);

EXIT;
?>
