<?php
namespace DAO\GoodsClass;
/**
 * User: liuyuzhen
 * Date: 2018/7/18
 * Time: 10:58
 * Description:
 */
class PlatformFirstClassModel extends \DAO\AbstractModel{
    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_platform_first_class';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'gc_parent_id';

    public function init(){

    }


    public function findByWhere($where){
        $this->setDb(\Our\DbNameConst::salveDBConnectName);
        $address  = $this->db->from($this->_tableName)->where($where)->fetchOne();
        return $address;
    }


    public function getList($where,$field = \Our\NameConst::allField){
        $this->setDb($this->dbName);
        $result = $this->db->select($field)->from($this->_tableName)->where($where)->fetchAll();
        return $result;
    }


    public function getStoreOnlineGoodsClassesByGcIdFromCache($gcId,$storeId,$field = \Our\NameConst::allField){
        $gcIds = \Our\RedisHelper::cachedFunction(\Redis\Db6\StoreOnlineGoodsClassRedisModel::getInstance(),array(&$this, 'getStoreOnlineGoodsClassesByGcId'),array($gcId,$storeId,$field),\Our\ApiConst::oneDaySecond,array($storeId));
        return $gcIds;
    }

    public function getStoreOnlineGoodsClassesByGcId($gcId,$storeId,$field = \Our\NameConst::allField){
        $where['gc_id_1'] = $gcId;
        $where['store_id'] = $storeId;
        $list = $this->getList($where);
        if($list){
            $platThirdGcIds = array();
            $storeThirdGcIds = array();
            $secondGcIds = array_unique(array_column($list,'gc_id_2'));
            $treeGcIds =array();
            foreach($list as $temp){
                if($temp['gc_from']==\Our\ApiConst::zero){
                    $platThirdGcIds[] = $temp['gc_id_3'];
                }else{
                    $storeThirdGcIds[] = $temp['gc_id_3'];
                }
                if(!(isset($treeGcIds[$temp['gc_id_2']][$temp['gc_from']])&&in_array($temp['gc_id_3'], $treeGcIds[$temp['gc_id_2']][$temp['gc_from']]))){
                    $treeGcIds[$temp['gc_id_2']][$temp['gc_from']][] = $temp['gc_id_3'];
                }
            }
            $platThirdGcIds = array_unique($platThirdGcIds);
            $storeThirdGcIds = array_unique($storeThirdGcIds);
            return array('secondGcIds'=>$secondGcIds,'treeGcIds'=>$treeGcIds,'platThirdGcIds'=>$platThirdGcIds,'storeThirdGcIds'=>$storeThirdGcIds);
        }
        return false;
    }

    /**
     * 检查获取店铺一级在售分类传参是否正确
     */
    public function checkStoreTopClasses($data){
        if(!isset($data['storeId'])){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyStoreIdForOnlineTopClass);
        }
    }
    /**
     * 检查获取店铺下级在售分类及广告传参是否正确
     */
    public function checkStoreChildrenClasses($data){
        if(!isset($data['storeId'])){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyStoreIdForOnlineChildrenClass);
        }
        if(!isset($data['gcId'])){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emtpyGcIdForOnlineChildrenClass);
        }
    }

    /**
     * 商品详情发生改变存如缓存
     * @param $goodsCommon goodsCommon详情
     * @param int $type 操作类型(1:加,0:减)
     * @return bool
     */
    public function addGoodsToGoodsClassCache($goodsCommon,$type = \Our\ApiConst::plus){
        if(!$goodsCommon){
            return false;
        }
        $goodsClass['gc_id_1'] = $goodsCommon['gc_id_1'];
        $goodsClass['gc_id_2'] = $goodsCommon['gc_id_2'];
        $goodsClass['gc_id_3'] = $goodsCommon['gc_id_3'];
        $goodsClass['store_id'] = $goodsCommon['store_id'];
        $goodsClass['gc_from'] = \Our\ApiConst::zero;
        if($goodsClass['gc_id_3']){
            $this->addChangedGoodsClass(serialize($goodsClass),$type);
        }
        if($goodsCommon['goods_class_t_id']){
            $goodsClass['gc_id_3'] = $goodsCommon['goods_class_t_id'];
            $goodsClass['gc_from'] = \Our\ApiConst::one;
            $this->addChangedGoodsClass(serialize($goodsClass),$type);
        }
        return true;
    }

    public function addChangedGoodsClass($goodsClass,$type = \Our\ApiConst::plus){
        $key='changedAddGoodsClass';
        if($type==\Our\ApiConst::minus){
            $key = 'changedMinusGoodsClass';
        }
        $storeOnlineClassRedisModel = \Redis\Db6\StoreOnlineGoodsClassRedisModel::getInstance();
        $storeOnlineClassRedisModel->tableLPush($key,$goodsClass);
    }

    public function getChangedGoodsClass($type = \Our\ApiConst::plus){
        $key='changedAddGoodsClass';
        if($type==\Our\ApiConst::minus){
            $key = 'changedMinusGoodsClass';
        }
        $storeOnlineClassRedisModel = \Redis\Db6\StoreOnlineGoodsClassRedisModel::getInstance();
        return $storeOnlineClassRedisModel->tableLPop($key);
    }

    /**
     * 获取更改商品
     * @param $start 记录开始条数
     * @param $end  记录结束条数
     * @return \Redis\mix
     */
    public function getChangedGoodsClasses($start,$end,$type = \Our\ApiConst::plus){
        $key='changedAddGoodsClass';
        if($type==\Our\ApiConst::minus){
            $key = 'changedMinusGoodsClass';
        }
        $storeOnlineClassRedisModel = \Redis\Db6\StoreOnlineGoodsClassRedisModel::getInstance();
        return $storeOnlineClassRedisModel->tableLRange($key,$start,$end);
    }

    /**
     * 类实例
     */
    private static $_instance = null;

    /**
     * 获取类实例
     */
    public static function getInstance($dbName= \Our\DbNameConst::salveDBConnectName) {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }
}