<?php

namespace Business\User;


class FeedBackServiceModel extends \Business\AbstractModel
{


    public function init() {

    }

    public function saveFeedback($param,$memberId){
        $feedbackDescribe = trim($param['feedbackDescribe']);
        $feedbackTelepone = trim($param['feedbackTelepone']);
        $feedbackTelephone = trim($param['feedbackTelephone']);
        $telephone = $feedbackTelepone ?  $feedbackTelepone : $feedbackTelephone;
        $type = (int)$param['type'];
        if(!$feedbackDescribe || mb_strlen($feedbackDescribe) < 10){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyFeedbackDescribe);
        }
//        if(!$telephone){
//            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyFeedbackDescribe);
//        }
//        $return = \Our\Common::checkMobilePhone($telephone);
//        if($return === false){
//            \Error\ErrorModel::throwException(\Error\CodeConfigModel::feedbackTelError);
//        }
        $imgArr = array();
        for ($i = 0 ; $i < 2 ; $i++){
            $number = str_replace(array(0,1,2),array('A','B','C'),$i);
            $image = $param['image'.$number];
            if($image && $type == 0){
                $time = date('YmdHis_');
                $file_name = $time.\Our\Validate::getNumberString();
                $result = \Our\ImageUtil::uploadBase64Image($image,\Our\ImageConst::feedback,$file_name);
                if($result){
                    $result = \Our\Common::getStaticFile($file_name,\Our\ImageConst::feedback);
                    $imgArr[] = pathinfo($result)['basename'];
                }
            }else{
                $imgArr[] = pathinfo($image)['basename'];
            }
        }
        $insert = array();
        $insert['feedback_image'] = serialize($imgArr);
        $insert['feedback_describe'] = $feedbackDescribe;
        $insert['feedback_time'] = time();
        $insert['feedback_telephone'] = $telephone;
        $insert['member_id'] = $memberId;

        $return = \DAO\FeedBackModel::getInstance()->insert($insert);
        if(!$return){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::saveFeedbackError);
        }
    }
    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

}
