<?php

namespace DAO\Member;
/**
 * User: liuyuzhen
 * Date: 2018/8/3
 * Time: 10:10
 * Description:
 */
class MemberMemberMappingModel extends \DAO\AbstractModel{

    public function init(){
    }
    /**
     * @param $where
     * @param $memberId
     * @return bool
     * @throws \Error\OurExceptionModel
     * @throws \Exception
     */
    public function checkBindMobileCommon($where,$memberId,$loginUserType){

        $dbName = \Our\DbNameConst::masterDBConnectName;
        $memberDao = \DAO\MemberModel::getInstance($dbName);
        $memberMappingDao = \DAO\MemberMappingModel::getInstance($dbName);
        $mobile = $where['mobile'];
        if (!\Our\Common::checkMobilePhone($mobile)) {
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::wrongMobileFormat);
        }
        $selfMemberMapping = $memberMappingDao->find(array('member_id'=>$memberId,'user_type'=>$loginUserType));
        /*if($selfMemberMapping){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::wrongMappingDataForBindMembmer);
        }*/
        //验证当前用户的mapping数据是否存在其他对应有效的绑定手机号码的用户,如果存在,则当前账号不能绑定手机号码
        $mappingCon['member_id'] = array('neq',$memberId);
        $mappingCon['user_type'] = $loginUserType;
        $mappingCon['openid'] = $selfMemberMapping['openid'];
        $otherMemberMappings = $memberMappingDao->getList($mappingCon,'member_id');
        if($otherMemberMappings){
            $otherMemberIds = array_column($otherMemberMappings,'member_id');
            $memberCon['member_id']  = array('notin',$otherMemberIds);
            $memberCon['member_mobile_bind'] = \Our\ApiConst::one;
            $memberCon['member_mobile'] = array('neq',\Our\NameConst::emptyString);
            $memberCon['member_state'] = \Our\ApiConst::one;
            $otherMemberList = $memberDao->getList($memberCon,'member_id');
            if($otherMemberList){
                \Error\ErrorModel::throwException(\Error\CodeConfigModel::otherMemberOpenIdBindForMember);
            }
        }
        //当前手机号码存在用户是否有对应的mapping数据,如果存在mapping数据,也认为该账号不能被绑定
        $mobileMember = $memberDao->getOneByWhereWithField(array('member_mobile' => $mobile, 'member_state' => \Our\ApiConst::one), 'member_id');
        if ($mobileMember) {
            $mobileMappingCon['member_id'] = $mobileMember['member_id'];
            $mobileMappingCon['user_type'] = $loginUserType;
            //$mappingCon['openid'] = $selfMemberMappingList[0]['openid'];
            $mobileMappings = $memberMappingDao->getList($mobileMappingCon,'member_id');
            if($mobileMappings){
                \Error\ErrorModel::throwException(\Error\CodeConfigModel::currentMobileHasBeenBind);
            }
            return $mobileMember;
        }
        return false;
    }

    /**
     * 类实例
     */
    private static $_instance = null;

    /**
     * 获取类实例
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}