<?php

namespace DAO;


class PBundlingModel extends \DAO\AbstractModel {



    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_p_bundling';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'bl_id';
    public function init(){

    }

//    public function getOtherListByStoreId($store_id,$group_id){
//        $this->setDb();
//        if(!$store_id || !$group_id){
//            return false;
//        }
//        $field = '';
//        $where = array();
//        $groupList=$this->db->select($field)->from($this->_tableName)->where($where)->order('gmt_create','DESC')->fetchOne();
//    }

    /**
     * @param $field
     * @param $where
     * @param array $limit
     * @param int $isDel 是否包含已删除数据(0:不包含,1包含)
     * @return mixed
     */
    public function getList($field,$where,$limit = [],$isDel = \Our\ApiConst::zero){
        $this->setDb($this->dbName);
        if(is_array($where)){
            $where = $this->db->getSqlWhereByArray($where);
        }
        $this->db->select($field)->from($this->_tableName)->where($where)->where("bl_quota_starttime <= ".time())->where('bl_quota_endtime >= '.time())->where('bl_state=1');
        if($isDel==\Our\ApiConst::zero){
            $this->db->where('is_del=0');
        }
        if($limit){
            $this->db->limit($limit[0],$limit[1]);
        }
        $result =  $this->db->fetchAll();
        return $result;
    }
    public function getImgPath($image){
        if($image){
            return \Our\Common::getStaticFile($image,\Our\ImageConst::storeLabel,'ossHost');
        }
    }

    public function getDetail($where,$field,$limit=false){
        $this->setDb($this->dbName);
        return $this->db->select($field)->from($this->_tableName)->join('han_p_bundling_goods',"han_p_bundling_goods.bl_id = han_p_bundling.bl_id",'inner')->where($where)->where("bl_quota_starttime <= ".time())->where('bl_quota_endtime >= '.time())->where('bl_state=1')->where('is_del=0')->limit($limit[0],$limit[1])->fetchAll();
    }
    public function getCount($where){
        $this->setDb($this->dbName);
        return $this->db->from($this->_tableName)->where($where)->where("bl_quota_starttime <= ".time())->where('bl_quota_endtime >= '.time())->where('bl_state=1')->where('is_del=0')->fetchNum();
    }


    public function find($where,$field = \Our\NameConst::allField){
        $this->setDb($this->dbName);
        $data = $this->db->from($this->_tableName)->select($field)->where($where)->fetchOne();
        return $data;
    }

    public function findById($blId,$field = \Our\NameConst::allField){
        $where['bl_id'] = $blId;
        $data = $this->find($where,$field);

        return $data;
    }

    public function getBlGoodsStorage($blId){
        $pBundlingRedis = \Redis\Db4\PBundlingRedisModel::getInstance();
        $storage =  $pBundlingRedis->tableHGet(\Our\NameConst::onlineStorageBlGoodsPrefix,$blId);
        if($storage === false){
            $field = 'bl_storage';
            $pBundling  = $this->findById($blId,$field);
            if($pBundling){
                $storage = $pBundling['bl_storage'];
                $pBundlingRedis->tableHSet(\Our\NameConst::onlineStorageBlGoodsPrefix,$blId,$pBundling['bl_storage'],\Our\ApiConst::oneDaySecond);
            }else{
                $storage = \Our\ApiConst::zero;
            }
        }
        return $storage;
    }


    public function opBlGoodsStorage($blId,$num ,$op = \Our\ApiConst::minus){
        if(!($blId&&$num>0)){
            return false;
        }
        $storeage = $this->getBlGoodsStorage($blId);
        if($storeage>=$num&&$op == \Our\ApiConst::minus){
            $storeage -= $num;
        }else if($op == \Our\ApiConst::plus){
            $storeage += $num;
        }else if($op == \Our\ApiConst::set){
            $storeage = $num;
        }else{
            return false;
        }
        $pBundlingRedis = \Redis\Db4\PBundlingRedisModel::getInstance();
        $result = $pBundlingRedis->tableHSet(\Our\NameConst::onlineStorageBlGoodsPrefix,$blId,$storeage,\Our\ApiConst::oneDaySecond);
        $this->deletePBundlingByBlId($blId);
        return $result;
    }

    public function updateBlStorage($dataList){
        $datas = array_values($dataList);
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $error = 0;
        $baseSql = "UPDATE {$this->_tableName} set bl_storage = case bl_id ";
        $updateAllSql = $baseSql;
        $dataIds = array();
        for ($i = 0; $i < count($datas); $i++) {
            $updateSql = \Our\Common::format(" WHEN {0} THEN bl_storage-{1} ", $datas[$i]['blId'], $datas[$i]['blStorage']);
            $dataIds[] = $datas[$i]['blId'];
            $updateAllSql .= $updateSql;
            if ($i % 1000 == 0 && $i != 0) {
                $updateAllSql .= \Our\Common::format('END where bl_id in ({0})',implode(',',$dataIds));
                $one = $this->db->update($this->_tableName)->query($updateAllSql);
                if (!$one) {
                    $error++;
                }
                $updateAllSql = $baseSql;
                $dataIds = array();
            }
        }
        if ($updateAllSql != $baseSql) {
            $updateAllSql .= \Our\Common::format('END where bl_id in ({0})',implode(',',$dataIds));
            $one = $this->db->update($this->_tableName)->query($updateAllSql);

            if (!$one) {
                $error++;
            }
        }
        if ($error > 0) {
            return false;
        }
        return true;
    }



    public function  getPBundlingCacheByBlId($blId){
        $pBundlingDao = \Redis\Db4\PBundlingRedisModel::getInstance();
        return $pBundlingDao->getByKeys('gid_'.$blId);
    }

    public function deletePBundlingByBlId($blId){
        $pBundlingDao = \Redis\Db4\PBundlingRedisModel::getInstance();
        $pBundlingDao->tableDelAll($pBundlingDao->tableKeys('gid_'.$blId));
    }

    public function deletePBundlingByGoodsCommonId($goodsCommonId){
        $pBundlingDao = \Redis\Db4\PBundlingRedisModel::getInstance();
        $pBundlingDao->tableDelAll($pBundlingDao->tableKeys('*'.\Our\NameConst::blGoods.$goodsCommonId));
    }

    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance($dbName = \Our\DbNameConst::salveDBConnectName) {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }


}
