<?php
namespace Payment;
/**
 * 微信支付
 * User: liuyuzhen
 * Date: 2018/7/3
 * Time: 9:24
 * Description:
 */

class WxPay extends \Payment\TencentPay{

   public function __construct()
   {
       $this->appid = \Our\PayConst::wxPayAppId;
       $this->notify_url = \Our\NameConst::httpPrefix.$_SERVER['SERVER_NAME'].\Our\PayConst::wxAppNotifyUrl;
       $this->mch_id = \Our\PayConst::wxPayMchId;
       $this->key = \Our\PayConst::wxPayKey;
       $this->sslcert_path = \Our\PayConst::wxSslcertPath;
       $this->sslkey_path = \Our\PayConst::wxSslkeyPath;
       $this->pay_url = \Our\PayConst::wxPayUrl;
       $this->tradeType = \Our\PayConst::wxAppTradeType;
   }

    public function doPay($orderInfo){
        $this->setRequestParams($orderInfo);
        $wxAppParameters = $this->getParameters();
        $returnData = array(
            'credential'=>array(\Our\NameConst::wxAppChannel=>$wxAppParameters),
            'app_id'=>$this->appid
            );
        return $returnData;
    }

    /**
     * 	作用：设置APP支付的参数
     */
    public function getParameters()
    {
        $wxApiObj["appid"] = $this->appid;
        $timeStamp = TIMESTAMP;
        $wxApiObj['partnerid'] = $this->mch_id;
        $wxApiObj["timestamp"] = "$timeStamp";
        $wxApiObj["noncestr"] = \Our\CommonExtension::createNoncestr();
        $wxApiObj["package"] = "Sign=WXPay";
        $wxApiObj['prepayid'] = $this->prepay_id;
        $wxApiObj["sign"] = $this->getSign($wxApiObj);
        return $wxApiObj;
    }


    /**
     * 类实例
     *
     */
    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

}
