<?php
/**
 *
 * 脚本
 *
 * @author ccw <31435391@qq.com>
 */
define("APPLICATION_PATH", realpath(dirname(__FILE__) . '/../../../')); //指向public的上一级

$http = new swoole_http_server("0.0.0.0", 9501);

/**
 * 测试在 $server 外部注册全局自定义属性, 看看会不会被覆盖
 */

$http->myWorkerVar = 'global';

$http->set(array(
    'worker_num' => 2,
    'daemonize' => false,
));

// 服务器启动时执行一次
$http->on('Start', function (Swoole_Http_Server $server) {
    echo PHP_EOL . PHP_EOL . 'Start: http://b.shenbd.com' . PHP_EOL . PHP_EOL;
});

// 服务器启动时执行一次
$http->on('ManagerStart', function (Swoole_Http_Server $server) {
    echo 'ManagerStart: ' . PHP_EOL . PHP_EOL;
});

// 每个 Worker 进程启动或重启时都会执行
$http->on('WorkerStart', function (Swoole_Http_Server $server,$workerId) {
    // 通过重新加载外部文件来重载代码和释放之前占用的内存
    //include_once __DIR__ . DIRECTORY_SEPARATOR .'workerstart.php';
    // 下面这些直接写在当前文件中的代码即便重载也不会变化

    echo 'WorkerStart: ' . PHP_EOL . PHP_EOL;
    echo '    Worker ID: ' . $workerId . PHP_EOL . PHP_EOL;
    // 启动服务器后, 去掉下面这行注释, 然后 reload , 该语句也不会执行的
    //echo '        reloaded ! ' . PHP_EOL . PHP_EOL;
    // 应该把这里的回调事件代码写在另一个文件中来 include 而不是直接写在这里
    // 注意即便是 include_once , reload 也会重新加载的, 但在你的逻辑控制中是有效的
});

// 每次连接时(相当于每个浏览器第一次打开页面时)执行一次, reload 时连接不会断开, 也就不会再次触发该事件
$http->on('Connect', function (Swoole_Http_Server $server, $fd,$reactorThreadId) {
    echo 'Connect: ' . PHP_EOL . PHP_EOL;
    echo '    Worker ID: '. $server->worker_id . PHP_EOL . PHP_EOL;
    echo '        fd: ' . $fd . ' , fromId: ' . $reactorThreadId . PHP_EOL . PHP_EOL;
});

$http->on('request', function ($request, $response) {
    require_once APPLICATION_PATH . '/scripts/crontab/common.php';
    require_once APPLICATION_PATH . '/scripts/crontab/push/bridgeBase.php';
});
$http->start();


