<?php
/**
 * User: liuyuzhen
 * Date: 2019/1/9
 * Time: 16:52
 * Description:
 */
namespace DAO\Store;

class ClassStoreModel extends \DAO\AbstractModel{

    protected function init()
    {

    }

    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_class_store';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';

    public function findByWhere($where){
        $this->setDb(\Our\DbNameConst::salveDBConnectName);
        $address  = $this->db->from($this->_tableName)->where($where)->fetchOne();
        return $address;
    }


    public function getList($where,$field = \Our\NameConst::allField,$orders = array('gc_parent_id'=>'asc','gc_sort'=>'asc','gc_id'=>'asc')){
        $this->setDb($this->dbName);
        $this->db->select($field)->from($this->_tableName);
        if($orders){
            foreach($orders as $key=>$val){
                $this->db->order($key,$val);
            }
        }
        $result = $this->db->where($where)->fetchAll();
        return $result;
    }
    /**
     * 类实例
     */
    private static $_instance = null;

    /**
     * 获取类实例
     */
    public static function getInstance($dbName= \Our\DbNameConst::salveDBConnectName) {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

}

