<?php

namespace DAO;


class PBundlingGoodsModel extends \DAO\AbstractModel {



    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_p_bundling_goods';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'bl_goods_id';
    public function init(){

    }


    public function getList($field,$where){
        $this->setDb($this->dbName);
        if(is_array($where)){
            $where = $this->db->getSqlWhereByArray($where);
        }
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchAll();
    }

    public function getDetail($where,$field,$limit=false){
        $this->setDb($this->dbName);
        return $this->db->select($field)->from($this->_tableName)->join('han_p_bundling_goods',"han_p_bundling_goods.bl_id = han_p_bundling.bl_id",'inner')->where($where)->where("bl_quota_starttime <= ".time())->where('bl_quota_endtime >= '.time())->where('bl_state=1')->limit($limit)->fetchAll();
    }

    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;


    /**
     * 获取类实例
     */
    public static function getInstance($dbName=\Our\DbNameConst::salveDBConnectName) {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }


}
