<?php

namespace DAO;


use Our\ApiConst;
use Our\Common;
use Our\CommonExtension;

/**
 * 商品报表模型类
 * Class StatGoodsModel
 * @package DAO
 * User: King <358887571@qq.com>
 * Date: 2018/11/30 0030
 * Time: 下午 5:30
 *
 */
class StatGoodsModel extends \DAO\AbstractModel {

    public $errorCode;

    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_stat_goods';

    private $cartGoodsField = 'goods_id,goods_storage,store_id,goods_commonid,goods_name,goods_image,goods_spec,snapshot_id';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'statg_id';
    public function init(){
    }

    /**
     *
     * 分页获取商品列表
     * @param $where
     * @param $field
     * @param $pageIndex
     * @param $pageSize
     * @param array $order
     * @return array|mixed
     */
    public function getListPage($where, $field, $pageIndex, $pageSize, $order = array('goods_id' => 'asc'))
    {
        $this->setDb($this->dbName);
        if($datas = $this->lists($where, $order, $field, $pageIndex, $pageSize)) {
            foreach ($datas['list'] as $key=>$val) {
                $datas['list'][$key]['goodsAttr'] = $this->getFormatGoodsAttr($val['goodsAttr']);
            }
        }
        return $datas ? $datas : array();
    }

    /**
     * 根据条件更新
     * @param $sql
     * @return mixed
     * User: King <358887571@qq.com>
     * Date: 2018/11/27 0027
     * Time: 下午 7:27
     */
    public function updatBySql($sql) {
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        return $this->db->update($this->_tableName)->execute($sql);
    }

    /**
     * 更新数据
     * @param $data
     * @param $where
     * @return mixed
     */
    public function update($where, $data, $setData = array())
    {
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $this->db->update($this->_tableName)->where($where)->rows($data);
        foreach ($setData as $val) {
            $this->db->set($val['field'], $val['value'], TRUE);
        }
        return $this->db->execute();
    }

    /**
     * 插入数据
     * @param $data
     * @return mixed
     * User: King <358887571@qq.com>
     * Date: 2018/11/27 0027
     * Time: 下午 5:51
     */
    public function insert($data){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $result = $this->db->insert($this->_tableName)->rows($data)->execute();
        return $result ;
    }

    public function getList($where,$field){
        $this->setDb();
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchAll();
    }

    public function find($where,$field = \Our\NameConst::allField){
        $this->setDb($this->dbName);
        $result = $this->db->select($field)->from($this->_tableName)->where($where)->fetchOne();
        return $result;
    }

    /**
     * 获取在线商品列表
     * @param $where
     * @param string $field
     * @return mixed
     */
    public function getOnlineList($where,$field = \Our\NameConst::allField){
        $whereSql = ' goods_state ='.\Our\ApiConst::onlineGoodsState.' and goods_verify='.\Our\ApiConst::onlineGoodsVerify.' and is_del='.\Our\ApiConst::onlineGoodsDel;
        if($where){
            $whereSql .= ' and '.$where;
        }
        return $this->getList($whereSql,$field);
    }

    public function getOnlineOne($goodsId,$field= \Our\NameConst::allField){
        $where['goods_state'] = \Our\ApiConst::onlineGoodsState;
        $where['goods_verify'] = \Our\ApiConst::onlineGoodsVerify;
        $where['is_del'] = \Our\ApiConst::onlineGoodsDel;
        $where['goods_id']  = $goodsId;
        $goods = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsRedisModel::getInstance(),array(&$this, 'find'),array($where,$field),\Our\ApiConst::oneHour,array($goodsId));
        return $goods;
    }

    /**
     * 类实例
     */
    private static $_instance = null;

    /**
     * 获取类实例
     */
    public static function getInstance($dbName=\Our\DbNameConst::salveDBConnectName) {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

}
