/*
   infosec_api.h
   
   The header file of ICBC demanded API writen in ANSI C
   Written by Yang Hongxuan (yanghx <yanghx@infosec.com.cn>)
  
   Copyright (C) 2002, Infosec Century, Inc. Created 2002. 
   All rights reserved.
*/

#ifndef _INFOSEC_API_
#define _INFOSEC_API_

#if defined(_WIN32)	
	#if defined( _DLLEXPORT_ )
		#define DLLENTRY	__declspec(dllexport)
	#else
		#define DLLENTRY	//__declspec(dllimport)
	#endif
#else
	#define DLLENTRY
#endif

#ifdef          __cplusplus
extern "C" {
#endif


#ifndef  _RETURN_VALUE_
#define  _RETURN_VALUE_
typedef enum RETURN_VALUE
{
	RET_SUCCESS = 0,
	ERR_BAD_PARAMETERS = -1,
	ERR_MALLOC = -2,
	ERR_PUBLICKEY_ENCODE = -3,
	ERR_PUBLICKEY_DECODE = -4,
	ERR_PRIVATEKEY_ENCODE = -5,
	ERR_PRIVATEKEY_DECODE = -6,
	ERR_PUBLICKEY_ENCRYPT = -7,
	ERR_PUBLICKEY_DECRYPT = -8,
	ERR_PRIVATEKEY_ENCRYPT = -9,
	ERR_PRIVATEKEY_DECRYPT = -10,
	ERR_CEA_ENCRYPT = -11,
	ERR_CEA_DECRYPT = -12,
	ERR_GET_CERT_INFO = -13,
	ERR_GEN_KEY = -14,
	ERR_MPI_CONVERT = -15,
	ERR_FILE = -16,
	ERR_MD	= -17,
	ERR_DIGEST = -18,
	ERR_UNEQUAL = -19,
	ERR_BASE64_ENCODE = -20,
	ERR_BASE64_DECODE = -21,
	ERR_OTHER = -22,
} RETURN_VALUE;
#endif

/*
Description:
  sign a string

parameter:
      src           (in)--data to be sign
      srcLen        (in)--src 's length
      privateKey    (in)--private key
      keyLen        (in)--private key len
      keyPass       (in)--private key password,must be '\0' end string
      signBuf       (out)-signature data buffer
      signBufLen    (out)-signature buffer' length

return:
      0  for successful
      -1 src error
      -2 private key error  
      -3 decrypt error
remark:
     the caller has obligation to free the  'signBuf'
*/
DLLENTRY int sign
( 
  unsigned char *src,
  int srcLen,
  unsigned char *privateKey,
  int keyLen,
  char *keyPass,
  unsigned char **signBuf,
  int *signBufLen
);
/*
Description:
  verify a signature

parameter:
      src           (in)--data to be verify
      srcLen        (in)--src 's length
      cert          (in)--certificate
      certLen       (in)--certificate len
      signBuf       (in)--signature buffer
      signBufLen    (in)--signature buffer' length

return:
      0  signature is good
      -1 decode cert failure
*/
DLLENTRY int verifySign
(
   unsigned char *src,
   int srcLen,
   unsigned char *cert,
   int certLen,
   unsigned char *signBuf,
   int signBufLen
);
/*
Description:
  base64 encode

parameter:
      src           (in)--src to be encoded
      srcLen        (in)--src len
      dst           (out)-base64 encode result
      dstLen        (out)-dst len
return:
      0  get ok
      -1 failure
remark:
     caller must free "dst"
*/
DLLENTRY int base64enc(unsigned char *src,int srcLen,unsigned char **dst,int *dstLen);

/*
Description:
  base64 decode

parameter:
      src           (in)--src to be decode
      srcLen        (in)--src len
      dst           (out)-base64 decode result
      dstLen        (out)-dst len
return:
      0  get ok
      -1 failure
remark:
     caller must free "dst"
*/
DLLENTRY int base64dec(unsigned char *src,int srcLen,unsigned char **dst,int *dstLen);
/*
Description:
  get certificate ID

parameter:
      mertCert           (in)--certificate
      mertCertLen        (in)--cert len
      id                 (out)-id
      idLen              (out)-id len
return:
      0  get ok
      -1 failure
remark:
     caller must free "id"
*/
DLLENTRY int getCertID(unsigned char *mertCert,int mertCertLen,char **id,int *idLen);

//DLLENTRY void infosec_free(void *dst);

/*******************************************************/
/*                  part 1 : RSAĲ                 */
/*******************************************************/

/* ˵Կп˽Կ 
   ֵɹ 0  ʧ 0 
   ע⣺ŹԿ˽ԿĻɽӿڷ䣬ͷ
         inKeyLen <= 4096 bits, inKeyLen32.
		 ʼΪ12345678
*/
DLLENTRY int genRSAKeyPwd
(
   int inKeyLen,             /*RSAģnı*/
   unsigned char *seed,      /*ӣ*/
   unsigned char **pubKeyBuf,/*湫ԿĻ*/
   int  *publicKeyLen,        /*ASN.1ĹԿĳ*/
   unsigned char **priKeyBuf,/*˽ԿĻ*/
   int *privateKeyLen,        /*ASN.1˽Կĳ*/
   char **initialKeyPass     /*˽Կĳʼ*/
);

/* ˵֤лùԿ 
   ע⣺pubKeyBufɽӿڷ䣬ͷ
   ֵɹ 0  ʧ 0 
*/
DLLENTRY int getPublicKey 
(
   unsigned char *cert,      /*֤ݣ*/
   int certLen,              /*֤ݵĳȣ*/
   unsigned char **publicKey,/*õĹԿĻ*/
   int *publicKeyLen         /*ùԿĳȣ*/
);

/*12 RSA˽ԿеĲ */ 

/* ˵ÿRSA˽Կ */
/* ע⣺encBufɽӿڷ䣬ͷ
   ֵɹ 0  ʧ 0
 */
DLLENTRY int privateEncryptPwd
(
  unsigned char *src,       /*Ҫܵ*/
  int srcLen,               /*Ҫܵݵֽ*/
  unsigned char *privateKey,/*˽Կ*/
  int keyLen,               /*˽Կֽ*/
  char *keyPass,            /**/
  unsigned char **encBuf,   /*ԺݴŵĻָ*/
  int *encBufLen            /*Ժݵĳ*/
);

/* ˵ÿRSA˽Կ */
/* ע⣺decBufɽӿڷ䣬ͷ
   ֵɹ 0  ʧ 0 */
DLLENTRY int privateDecryptPwd
(
   unsigned char *src,       /*Ҫܵ*/
   int srcLen,               /*Ҫܵݵֽ*/
   unsigned char *privateKey,/*˽Կ*/
   int keyLen,               /*˽Կֽ*/
   char *pass,               /**/
   unsigned char **decBuf,   /*ԺݴŵĻָ*/
   int *decBufLen            /*Ժݵĳ*/
);


/* ˵֤еRSAԿ */
/* ע⣺encBufɽӿڷ䣬ͷ
   ֵɹ 0  ʧ 0 */
DLLENTRY int publicEncryptCert
(
   unsigned char *src,    /*Ҫܵ*/
   int srcLen,            /*Ҫܵݵĳ*/
   unsigned char *cert,   /*֤*/
   int certLen,           /*֤鳤*/
   unsigned char **encBuf,/*ܺݻָ*/
   int *encBufLen         /*ܺݵĳ*/
);

/* ˵֤еRSAԿ */
/* ע⣺decBufɽӿڷ䣬ͷ
   ֵɹ 0  ʧ 0 */
/* Ϊʹ߷¼ӵĽӿ*/
DLLENTRY int publicDecryptCert
(
   unsigned char *src,    /*Ҫܵ*/
   int srcLen,            /*Ҫܵݵĳ*/
   unsigned char *cert,   /*֤*/
   int certLen,           /*֤鳤*/
   unsigned char **decBuf,/*ܺݻָ*/
   int *decBufLen         /*ܺݵĳ*/
);

/*********************************************************/
/*              part 2: Des                      */
/*********************************************************/

/* ˵DESܽӿ */
/* ֵɹ 0  ʧ 0 */
/* ע⣺encodedBufɽӿڷ䣬ͷ
         ĳȲ8ʱԶɸֵΪ0x00ֽڣ
		 ĳȱ8
*/
DLLENTRY int desEncrypt
(
	char *src, 
	int srcLen, 
	unsigned char *Key,
	int keyLen,
	unsigned char **encBuf,
	int *encBufLen
);

/* ˵DESܽӿ */
/* ֵɹ 0  ʧ 0 */
/* ע⣺encodedBufɽӿڷ䣬ͷ
         ĳȲ8ʱԶɸֵΪ0x00ֽڣ
		 ĳȱ8
*/
DLLENTRY int desDecrypt
(
	unsigned char *src, 
	int srcLen, 
	unsigned char *Key, 
	int keyLen, 
	unsigned char **decBuf,
	int *decBufLen
);


/* ˵һtripple DES/ܵԿ */
/* ע⣺keyBufɽӿڷ䣬ͷ
   ֵɹ 0  ʧ 0 */
DLLENTRY int genDESKey
(
   int length,            /*ҪԿĳ >= 24 */
   unsigned char *seed,   /**/
   unsigned char **keyBuf,/*Կ*/
   int *keyLen            /*Կĳ*/
);

//int getErrorInfo(char *err);
//char err[128];

#ifdef          __cplusplus
}
#endif

#endif
