<?php
namespace Business\Common;
/**
 * User: liuyuzhen
 * Date: 2018/8/7
 * Time: 16:11
 * Description:
 */
class CommonProblemServiceModel extends \Business\AbstractModel{

    public function getProblemList(){
        $articleDao = \DAO\Article\ArticleModel::getInstance();
        $articleList = \Our\RedisHelper::cachedFunction(\Redis\Db10\ArticleRedisModel::getInstance(),array(&$articleDao, 'getList'),array(array('ac_id'=>\Our\ApiConst::commonProblemArticleClassId),'article_id as problemId,article_title as problemTitle',array('article_sort'=>'asc','article_id'=>'desc')),\Our\ApiConst::oneHour,array(\Our\ApiConst::commonProblemArticleClassId));
        return $articleList;
    }

    public function getOneProblem($problemId){
        $articleDao = \DAO\Article\ArticleModel::getInstance();
        $article = \Our\RedisHelper::cachedFunction(\Redis\Db10\ArticleRedisModel::getInstance(),array(&$articleDao, 'find'),array(array('article_id'=>$problemId),'article_title as problemTitle,article_content as problemContent'),\Our\ApiConst::oneHour,array($problemId));
        return $article;
    }

    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}