<?php
namespace Business\User;
/**
 * User: liuyuzhen
 * Date: 2018/5/14
 * Time: 15:38
 * Description:短信验证码相关
 */
class ShortMessageServiceModel extends \Business\AbstractModel {

    public function init()
    {

    }

    /**
     * 获取验证码
     * @param $where
     * @param $member_id
     */
    public function getValidCode($where,$memberId = null){
        $messageType = $where['messageType'];
        $memberDao = \DAO\MemberModel::getInstance();
        if(\Our\ApiConst::messageTypeRegister == $messageType||\Our\ApiConst::messageTypeValidNewMobile == $messageType){
            $memberDao->checkRegisterMobile($where);
        }else if(\Our\ApiConst::messageTypeFindPassword  == $messageType){
            $memberDao->checkLoginMobile($where);
        }else if(\Our\ApiConst::messageTypeWxLietBindMobile == $messageType){ //已登录用户绑定手机号码
            $memberDao->checkWxBindMobileForSms($where,$memberId);
            $sess=\Yaf\Session::getInstance();
            $loginUserType = $sess->get('user_type');
            $memberMemberMappingDao = \DAO\Member\MemberMemberMappingModel::getInstance();
            $memberMemberMappingDao->checkBindMobileCommon($where,$memberId,$loginUserType);

        }else if(\Our\ApiConst::messageTypeSeller == $messageType){
            $memberDao->checkSaleMobile($where,$memberId);
        }
        $shortMessageDao = \DAO\ShortMessageModel::getInstance();
        $result = $shortMessageDao->sendSms($where);
        return $result;
    }


    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}