<?php
namespace DAO\GoodsClass;
/**
 * User: liuyuzhen
 * Date: 2018/7/18
 * Time: 17:52
 * Description:
 */
class GoodsClassThirdModel extends \DAO\AbstractModel{
    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_goods_class_third';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'goods_class_t_id';

    private $thirdStoreClassField = 'gc_name as gcName,goods_class_t_id as gcId,goods_class_image as gcImage';

    public function init(){

    }

    public function getList($where,$field = \Our\NameConst::allField){
        $this->setDb($this->dbName);
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchAll();
    }

    public function getListByIdsFromCache($ids){
        $field = $this->thirdStoreClassField;
        $returnList = \Our\RedisHelper::cachedFunction(\Redis\Db3\GoodsClassThirdModelRedisModel::getInstance(),array(&$this, 'getListByIds'),array($ids,$field),\Our\ApiConst::oneDaySecond);
        return $returnList;
    }

    public function getListByIds($ids,$field = \Our\NameConst::allField,$order = array('gc_sort'=>'asc')){
        if(!$ids){
            return false;
        }
        $this->setDb($this->dbName);
        if(is_array($ids)){
            $where[$this->_primaryKey] = array('in',$ids);
        }else{
            $where[$this->_primaryKey] = $ids;
        }
        $whereSql = $this->db->getSqlWhereByArray($where);
        $this->db->select($field)->from($this->_tableName)->where($whereSql);
        foreach($order as $key=>$val){
            $this->db->order($val,$key);
        }
        $list =$this->db->fetchAll();
        $returnList = array();
        if($list){
            foreach($list as $temp){
                $tempClass = $temp;
                $tempClass['gcImage'] = \Our\Common::getStaticFile($tempClass['gcImage'],\Our\ImageConst::storeClassAdvImagePrefix);
                $returnList[$temp['gcId']] = $tempClass;
            }
            return $returnList;
        }
        return false;
    }

    /**
     * 类实例
     */
    private static $_instance = null;

    /**
     * 获取类实例
     */
    public static function getInstance($dbName= \Our\DbNameConst::salveDBConnectName) {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }
}