<?php
namespace DAO\Adv;

/**
 *
 * User: liuyuzhen
 * Date: 2018/6/24
 * Time: 14:43
 * Description:
 */
class StoreAdvPositionModel extends \DAO\AbstractModel{

    /**
     * 表名
     */
    protected $_tableName = 'han_store_adv_position';

    /**
     * 主键
     */
    protected $_primaryKey = 'ap_id';

    public function init(){

    }
    public function find($where,$field = \Our\NameConst::allField){
        $this->setDb($this->dbName);
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchOne();
    }

    /**
     * 删除缓存
     * @param $apId
     * @throws \Our\Exception
     */
    public function deleteStoreAdvPositionCache($apId){
        \Our\RedisHelper::delCachedFunction(\Redis\Db9\StoreAdvPositionRedisModel::getInstance(),array(&$this, 'find'),array(),array($apId));
    }


    public function getList($where,$field = \Our\NameConst::allField,$order=null){
        $this->setDb($this->dbName);
        $this->db->select($field)->from($this->_tableName)->where($where);
        if($order){
            foreach($order as $key=>$value){
                $this->db->order($key,$value);
            }
        }
        $result = $this->db->fetchAll();
        return $result;
    }

    /**
     * 类实例
     */
    private static $_instance = null;

    /**
     * 获取类实例
     */
    public static function getInstance($dbName = \Our\DbNameConst::salveDBConnectName) {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }
}