<?php

namespace DAO\Order;

use Our\ApiConst;
use Our\ArrayConst;
use Our\Common;
use Our\DbNameConst;
use Our\DescribeConst;
use Our\NameConst;
use Our\OrderConst;


/**
 * 订单相关
 * @date 2018-5-14
 * @author csw
 */
class OrderLogModel extends \DAO\AbstractModel
{


    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_order_log';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'log_id';

    public function init()
    {
        //$this->setDb();
    }

    public function addLog($log){
        $this->setDb($this->dbName);
        $logId = $this->db->insert($this->_tableName)->rows($log)->execute();
        return $logId;
    }
    //添加退款操作日志
    public function addRefundOrderLog($orderId,$logMsgType,$logRole,$logUser,$logOrderState){
        $data['order_id']=$orderId;
        $data['log_msg']=ArrayConst::logMsgType[$logMsgType];
        $data['log_role']=$logRole;
        $data['log_user']=$logUser;
        $data['log_orderstate']=$logOrderState;
        $data['log_time']=TIMESTAMP;
        return $this->addLog($data);
    }

    public function insertAll($datas){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $error = 0;
        $baseSql = "insert IGNORE into {$this->_tableName}(order_id,log_msg,log_time,log_role,log_user,log_orderstate) values";
        $insertAllSql = $baseSql;
        for ($i = 0; $i < count($datas); $i++) {
            $addSql = \Our\Common::format("('{0}','{1}','{2}','{3}','{4}','{5}'),", $datas[$i]['order_id'], $datas[$i]['log_msg'], $datas[$i]['log_time'], $datas[$i]['log_role'], $datas[$i]['log_user'], $datas[$i]['log_orderstate']);
            $insertAllSql .= $addSql;
            if ($i % 1000 == 0 && $i != 0) {
                $insertAllSql = rtrim($insertAllSql, ',');
                $one = $this->db->insert($this->_tableName)->query($insertAllSql);
                if (!$one) {
                    $error++;
                }
                $insertAllSql = $baseSql;
            }
        }
        if ($insertAllSql != $baseSql) {
            $insertAllSql = rtrim($insertAllSql, ',');
            $one = $this->db->insert($this->_tableName)->query($insertAllSql);

            if (!$one) {
                $error++;
            }
        }
        if ($error > 0) {
            return false;
        }
        return true;
    }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;


    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance($dbName=DbNameConst::salveDBConnectName)
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

}
