/*
Module:	   		MPIFUNC.c
Author:  	 	Xu JianZhuo
LastModify:     1998/10/30
Description:
	This file contains several functions which can be called to process MPI.
	The functions include Add,Sub,RightShift,LeftShift,XOR,Copy.
	The largest lenth of the MPI can be defined by TY_MAX_LEN.

	yhx: It is used in no file other than cea.c
*/
#ifndef SUB_H
#define SUB_H

#ifdef __cplusplus
extern "C"{
#endif

typedef unsigned char * MPI;

extern void MPIAdd(MPI Source1,MPI Source2,MPI Result,int WordCount);
/*
Discription:
	1:This fuction perform Result=Source1+Source2
	2:The Source1 may equal to Source2
	3:The Result may equal to Source1 or Source2
Arguments:
	Source1,Source2,Result:The operand
	WordCount:  The lenth of the MPI (BYTE)
*/
extern void MPISub(MPI String1,MPI String2,MPI Result,int WordCount);
/*
Discription:
	1:This fuction perform Result=Source1-Source2
	2:The Source1 may equal to Source2
	3:The Result may equal to Source1 or Source2

Arguments:
	Source1,Source2,Result:The operand
	WordCount:  The lenth of the MPI (BYTE)
*/

//extern void MPIXor(MPI String1,MPI String2,MPI Result,int WordCount);
/*
Discription:
	1:This fuction perform Result=Source1^Source2
	2:The Source1 may equal to Source2
	3:The Result may equal to Source1 or Source2

Arguments:
	Source1,Source2,Result:The operand
	WordCount:  The lenth of the MPI (BYTE)
*/

extern void MPIRShift(MPI Input,MPI Output,int Count,int WordCount);
/*
Discription:
	1:This fuction perform OutPut=Input>>Count
	2:Input can be the same as Output
Arguments:
	Input,Output: The operand
	Count:        Bit count to shift
	WordCount:    The lenth of the MPI (BYTE)
*/

extern void MPILShift(MPI Input,MPI Output,int Count,int WordCount);
/*
Discription:
	1:This fuction perform OutPut=Input<<Count
	2:Input can be the same as Output

Arguments:
	Input,Output: The operand
	Count:        Bit count to shift
	WordCount:    The lenth of the MPI (BYTE)
*/

extern void MPICopy(MPI Source,MPI Target,int WordCount);
/*
Discription:
	This function perform Target=Source
Argument:
	Source,Target:	The operand
	WordCount:      The lenth of the MPI (BYTE)
*/

#ifdef __cplusplus
}
#endif

#define TY_MAX_LEN 64
/*The max lenth of the MPI string*/
#endif
