<?php
define("APPLICATION_PATH", realpath(dirname(__FILE__) . '/../../../')); //指向public的上一级
require APPLICATION_PATH . '/scripts/crontab/baseCli.php';
require APPLICATION_PATH . '/scripts/crontab/common.php';
error_reporting(E_ALL ^ E_NOTICE);

/**
 * 店铺数据统计
 * 执行时间：每分钟执行一次
 * Class cliStoreStat
 * User: King <358887571@qq.com>
 * Date: 2018/11/30 0030
 * Time: 下午 3:00
 *
 */
class cliStoreStat extends basecli
{
    const CLI_ADMIN_ID = 255;
    private $bDoUnLock  = FALSE;   // 是否允许释放 LOCK 文件
    private $_debug = 0;
    private $lockFileName;


    private function mkdirs($dir, $mode = 0777)
    {
        if (is_dir($dir) || @mkdir($dir, $mode)){
            return TRUE;
        }
        if (!$this->mkdirs(dirname($dir), $mode)){
            return FALSE;
        }
        return @mkdir($dir, $mode);
    }
    /**
     * 析构
     */
    public function __destruct()
    {
        parent::__destruct();
        if ($this->bDoUnLock)
        {
            @unlink($this->lockFileName);

        }
    }

    /**
     * 自动统计商品
     * User: linqin <358887571@qq.com>
     * Date: 2018/11/27 0027
     * Time: 下午 3:23
     */
    protected function autoStatGoods(){
        $service = \Business\Store\StoreServiceModel::getInstance(\Our\DbNameConst::masterDBConnectName);
        $service->baseDir = \Our\Common::getConfig('out.config');
        echo "update store stat \n";
        if($service->updateStatStore()) {  //更新商品基础信息
            echo "update store others \n";
            //$goodsService->updateStatGoodsSell();
        }
    }
    protected function _runCli()
    {

        $this->_debug = isset($this->aArgv[1]) ? intval($this->aArgv[1]) : 0;
        if ($this->_debug)
        {
            echo "*** Debug mode ***\n";
        }
        // Step: 02 检查是否已有相同CLI在运行中
        $lockDir=$this->_getBaseFileName('store');
        if(!$this->mkdirs($lockDir)){
            echo '****create dir fail  ****';
            exit;
        }
        $this->lockFileName = $lockDir .DS.'stat.locks';
        if( file_exists( $this->lockFileName ) )
        {
            $stat = stat($this->lockFileName);
            if( (TIMESTAMP - $stat['mtime']) > 1800 )
            {
                echo "文件被锁超过1800秒，被强制删除";
                @unlink($this->lockFileName);
            }
            else
            {
                $this->halt( '[' . date('Y-m-d H:i:s') .'] The CLI is running'."\n");
            }
        }
        $this->bDoUnLock = true;
        if(APP_ENV =='pre' || APP_ENV=='product'){
            file_put_contents($this->lockFileName ,"running" ); // CLI 独占锁
        }
        $this->autoStatGoods();

        echo date('Y-m-d H:i:s',TIMESTAMP).'定单关闭消息成功'."\r\n";
    }
}

$oCli = new cliStoreStat(TRUE);

EXIT;
?>
