<?php
namespace Payment;
/**
 * User: liuyuzhen
 * Date: 2018/7/5
 * Time: 11:39
 * Description:
 */
class WxLitePay extends \Payment\TencentPay{

    public function __construct()
    {
        $this->appid = \Our\PayConst::wxLiteAppId;
        $this->notify_url = \Our\NameConst::httpPrefix.$_SERVER['SERVER_NAME'].\Our\PayConst::wxLiteNotifyUrl;
        $this->mch_id = \Our\PayConst::wxPayMchId;
        $this->key = \Our\PayConst::wxPayKey;
        $this->sslcert_path = \Our\PayConst::wxSslcertPath;
        $this->sslkey_path = \Our\PayConst::wxSslkeyPath;
        $this->pay_url = \Our\PayConst::wxPayUrl;
        $this->tradeType = \Our\PayConst::wxLiteTradeType;
	}


    public function doPay($orderInfo){
        $this->setRequestParams($orderInfo);
        $wxAppParameters = $this->getParameters();
        $returnData = array(
            'credential'=>array(\Our\NameConst::wxLiteChannel=>$wxAppParameters),
            'app_id'=>$this->appid
        );
        return $returnData;
    }

    public function getParameters(){
        $wxApiObj["appId"] = $this->appid;
        $timeStamp = TIMESTAMP;
        $wxApiObj["timeStamp"] = "$timeStamp";
        $wxApiObj["nonceStr"] = \Our\CommonExtension::createNoncestr();
        $wxApiObj['package'] = 'prepay_id='.$this->prepay_id;
        $wxApiObj['signType'] = 'MD5';
        $wxApiObj["paySign "] = $this->getSign($wxApiObj);
        return $wxApiObj;
    }


    /**
     * 类实例
     *
     */
    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

}