<?php
namespace JPush;

use InvalidArgumentException;
use Our\ApiConst;
use Our\ArrayConst;
use Our\DescribeConst;
use Our\SecretKeys;

class ClientPush
{
   private $client;
    public function __construct()
    {
        $app_key = SecretKeys::pushKey;
        $master_secret = SecretKeys::pushSecret;
        //$registration_id = getenv('registration_id');
        $this->client = new Client($app_key, $master_secret);
    }
    public function pushAll(){
        $push_payload = $this->client->push()
            ->setPlatform('all')
            ->addAllAudience()
            ->setNotificationAlert('Hi, JPush');
        try {
            $response = $push_payload->send();
            print_r($response);
        } catch (\JPush\Exceptions\APIConnectionException $e) {
            // try something here
            print $e;
        } catch (\JPush\Exceptions\APIRequestException $e) {
            // try something here
            print $e;
        }
        return true;
    }

    private function getMessageType($type){
        $baseTitle=DescribeConst::appName;
        switch($type){
            case ApiConst::systemMessageType:$baseTitle=$baseTitle.ArrayConst::messageName[ApiConst::systemMessageType];break;
            case ApiConst::orderMessageType:$baseTitle=$baseTitle.ArrayConst::messageName[ApiConst::orderMessageType];break;
            case ApiConst::deliveryMessageType:$baseTitle=$baseTitle.ArrayConst::messageName[ApiConst::deliveryMessageType];break;
            case ApiConst::storeMessageType:$baseTitle=$baseTitle.ArrayConst::messageName[ApiConst::storeMessageType];break;
            case ApiConst::memberMessageType:$baseTitle=$baseTitle.ArrayConst::messageName[ApiConst::memberMessageType];break;
            default:$baseTitle;break;
        }
        return $baseTitle;
    }
    private function getMessageContent($message){
        $messageContent='新消息:';
        switch($message['type']){
            case ApiConst::reacheCallMessage:
            case ApiConst::refundReturnMessage:
            case ApiConst::deliveryChangeMessage:
            case ApiConst::autoSendMessage:
            case ApiConst::orderStateChangeMessage:
            case ApiConst::orderReceiveMessage:
            case ApiConst::orderMessageType:$messageContent=$message['content'];break;
            case ApiConst::onePictureMessage:$messageContent=DescribeConst::imageMessage;break;
            default:$messageContent=$messageContent.$message['content'];;break;
        }
        return $messageContent;
    }
    public function pushTest($pushData)
    {
        //  $pushFlag=(APP_ENV=='product' || APP_ENV=='productone')?true:false;
        $pushFlag=false;
        // echo json_encode($pushData);
        $title=$this->getMessageType($pushData['fromType']);
        $messageContent=$this->getMessageContent($pushData['message']);
         $pushObject=array('id'=>433,'memberName'=>'abc');
        $messageContent="testMessage";
        $title='tesetTitle';
          $pushData['toId']=433;
        echo $pushData['toId'];
        try {
            $response = $this->client->push()
                ->setPlatform('all')
                // 一般情况下，关于 audience 的设置只需要调用 addAlias、addTag、addTagAnd  或 addRegistrationId
                // 这四个方法中的某一个即可，这里仅作为示例，当然全部调用也可以，多项 audience 调用表示其结果的交集
                // 即是说一般情况下，下面三个方法和没有列出的 addTagAnd 一共四个，只适用一个便可满足大多数的场景需求

                ->addAlias((string)$pushData['toId'])
                // ->addTag(array($pushData['toId'], 'tag2'))
                //->addRegistrationId($pushData['toId'])

                ->setNotificationAlert($title)
                ->iosNotification($messageContent, array(
                    'sound' => 'sound.caf',
                    // 'badge' => '+1',
                    // 'content-available' => true,
                    // 'mutable-content' => true,
                    'category' => 'shenbd',
                    'extras' => $pushData,
                ))
                ->androidNotification($messageContent, array(
                    'title' =>$title,
                    // 'builder_id' => 2,
                    'extras' => $pushData,
                ))
                ->message($messageContent, array(
                    'title' => $title,
                    'content_type' => $pushData['message']['type'],
                    'extras' => $pushData,
                ))
                ->options(array(
                    // sendno: 表示推送序号，纯粹用来作为 API 调用标识，
                    // API 返回时被原样返回，以方便 API 调用方匹配请求与返回
                    // 这里设置为 100 仅作为示例

                    // 'sendno' => 100,

                    // time_to_live: 表示离线消息保留时长(秒)，
                    // 推送当前用户不在线时，为该用户保留多长时间的离线消息，以便其上线时再次推送。
                    // 默认 86400 （1 天），最长 10 天。设置为 0 表示不保留离线消息，只有推送当前在线的用户可以收到
                    // 这里设置为 1 仅作为示例

                    // 'time_to_live' => 1,

                    // apns_production: 表示APNs是否生产环境，
                    // True 表示推送生产环境，False 表示要推送开发环境；如果不指定则默认为推送生产环境

                    'apns_production' => $pushFlag,

                    // big_push_duration: 表示定速推送时长(分钟)，又名缓慢推送，把原本尽可能快的推送速度，降低下来，
                    // 给定的 n 分钟内，均匀地向这次推送的目标用户推送。最大值为1400.未设置则不是定速推送
                    // 这里设置为 1 仅作为示例

                    // 'big_push_duration' => 1
                ))
                ->send();
            print_r($response);

        } catch (\JPush\Exceptions\APIConnectionException $e) {
            // try something here
            print $e;
        } catch (\JPush\Exceptions\APIRequestException $e) {
            // try something here
            print $e;
        }
    }
    public function push($pushData)
    {
      //  $pushFlag=(APP_ENV=='product' || APP_ENV=='productone')?true:false;
        $pushFlag=true;
       // echo json_encode($pushData);
       $title=$this->getMessageType($pushData['fromType']);
        $messageContent=$this->getMessageContent($pushData['message']);
       // $pushObject=array('id'=>$toId,'memberName'=>'abc');
      //  $pushData['toId']=249;
        echo $pushData['toId'];
        try {
            $response = $this->client->push()
                ->setPlatform('all')
                // 一般情况下，关于 audience 的设置只需要调用 addAlias、addTag、addTagAnd  或 addRegistrationId
                // 这四个方法中的某一个即可，这里仅作为示例，当然全部调用也可以，多项 audience 调用表示其结果的交集
                // 即是说一般情况下，下面三个方法和没有列出的 addTagAnd 一共四个，只适用一个便可满足大多数的场景需求

                 ->addAlias((string)$pushData['toId'])
               // ->addTag(array($pushData['toId'], 'tag2'))
                //->addRegistrationId($pushData['toId'])

                ->setNotificationAlert($title)
                ->iosNotification($messageContent, array(
                    'sound' => 'sound.caf',
                    // 'badge' => '+1',
                    // 'content-available' => true,
                    // 'mutable-content' => true,
                    'category' => 'shenbd',
                    'extras' => $pushData,
                ))
                ->androidNotification($messageContent, array(
                    'title' =>$title,
                    // 'builder_id' => 2,
                    'extras' => $pushData,
                ))
                ->message($messageContent, array(
                    'title' => $title,
                    'content_type' => $pushData['message']['type'],
                    'extras' => $pushData,
                ))
                ->options(array(
                    // sendno: 表示推送序号，纯粹用来作为 API 调用标识，
                    // API 返回时被原样返回，以方便 API 调用方匹配请求与返回
                    // 这里设置为 100 仅作为示例

                    // 'sendno' => 100,

                    // time_to_live: 表示离线消息保留时长(秒)，
                    // 推送当前用户不在线时，为该用户保留多长时间的离线消息，以便其上线时再次推送。
                    // 默认 86400 （1 天），最长 10 天。设置为 0 表示不保留离线消息，只有推送当前在线的用户可以收到
                    // 这里设置为 1 仅作为示例

                    // 'time_to_live' => 1,

                    // apns_production: 表示APNs是否生产环境，
                    // True 表示推送生产环境，False 表示要推送开发环境；如果不指定则默认为推送生产环境

                    'apns_production' => $pushFlag,

                    // big_push_duration: 表示定速推送时长(分钟)，又名缓慢推送，把原本尽可能快的推送速度，降低下来，
                    // 给定的 n 分钟内，均匀地向这次推送的目标用户推送。最大值为1400.未设置则不是定速推送
                    // 这里设置为 1 仅作为示例

                    // 'big_push_duration' => 1
                ))
                ->send();
            print_r($response);

        } catch (\JPush\Exceptions\APIConnectionException $e) {
            // try something here
            print $e;
        } catch (\JPush\Exceptions\APIRequestException $e) {
            // try something here
            print $e;
        }
    }

    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @ccw push
     */
    public static function getInstance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}
